/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreUpdateRepoCommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={GitFacet.class, GitIgnoreFacet.class})
public class GitIgnoreUpdateRepoCommandImpl
extends AbstractGitCommand
implements GitIgnoreUpdateRepoCommand {
    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GITIGNORE: Update templates").description("Update the local .gitignore template repository");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result = null;
        try {
            ((GitIgnoreFacet)this.getSelectedProject((UIContextProvider)context).getFacet(GitIgnoreFacet.class)).update();
            result = Results.success((String)"Local gitignore repository updated.");
        }
        catch (IOException e) {
            result = Results.fail((String)("Error reading local repository: " + e.getMessage()), (Throwable)e);
        }
        catch (GitAPIException e) {
            result = Results.fail((String)("Error pulling remote repository: " + e.getMessage()), (Throwable)e);
        }
        return result;
    }
}

