/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.ip.StaticIPLocationModel;
import org.jboss.windup.rules.apps.java.model.PropertiesModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.files.condition.FileContent;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverStaticIPAddressRuleProvider
extends AbstractRuleProvider {
    private static final String IP_PATTERN = "(?<![\\w.])\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(?![\\w.])";
    private static final Logger LOG = Logger.getLogger(DiscoverStaticIPAddressRuleProvider.class.getSimpleName());

    public DiscoverStaticIPAddressRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverStaticIPAddressRuleProvider.class).setPhase(MigrationRulesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)FileContent.matches((String)"{ip}").inFileNamed("{*}.{type}")).perform((Operation)new AbstractIterationOperation<FileLocationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileLocationModel payload) {
                if (InetAddressValidator.getInstance().isValid(payload.getSourceSnippit())) {
                    if (DiscoverStaticIPAddressRuleProvider.this.ignoreLine(event.getGraphContext(), payload)) {
                        return;
                    }
                    StaticIPLocationModel location = (StaticIPLocationModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, StaticIPLocationModel.class);
                    location.setRuleID(((Rule)context.get(Rule.class)).getId());
                    location.setTitle("Static IP Address Detected");
                    StringBuilder hintBody = new StringBuilder("**Static IP: ");
                    hintBody.append(payload.getSourceSnippit());
                    hintBody.append("**");
                    hintBody.append("\n\n");
                    hintBody.append("When migrating environments, static IP addresses may need to be modified or eliminated.");
                    location.setHint(hintBody.toString());
                    location.setEffort(0);
                }
            }
        }).where("ip").matches(IP_PATTERN).where("type").matches("java|properties|xml").withId(((Object)((Object)this)).getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ignoreLine(GraphContext context, FileLocationModel model) {
        isPropertiesFile = model.getFile() instanceof PropertiesModel;
        lineNumber = model.getLineNumber();
        li = null;
        try {
            li = FileUtils.lineIterator((File)model.getFile().asFile());
            i = 0;
lbl7:
            // 3 sources

            while (li.hasNext()) {
                if (++i != lineNumber) ** GOTO lbl-1000
                line = StringUtils.trim((String)li.next());
                if (!isPropertiesFile || !StringUtils.startsWith((String)line, (String)"#")) ** GOTO lbl-1000
                var8_9 = true;
                ** GOTO lbl21
            }
            ** GOTO lbl41
        }
        catch (IOException | RuntimeException e) {
            try {
                DiscoverStaticIPAddressRuleProvider.LOG.log(Level.WARNING, "Exception reading properties from file: " + model.getFile().getFilePath(), e);
            }
            catch (Throwable var9_13) {
                LineIterator.closeQuietly(li);
                throw var9_13;
            }
lbl21:
            // 1 sources

            LineIterator.closeQuietly((LineIterator)li);
            return var8_9;
lbl-1000:
            // 1 sources

            {
                if (!StringUtils.containsIgnoreCase((String)line, (String)"version") && !StringUtils.containsIgnoreCase((String)line, (String)"revision")) ** GOTO lbl-1000
                var8_10 = true;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_10;
lbl-1000:
            // 1 sources

            {
                if (!this.isMavenVersionTag(context, model)) ** GOTO lbl-1000
                var8_11 = true;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_11;
lbl-1000:
            // 1 sources

            {
                var8_12 = false;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_12;
lbl-1000:
            // 1 sources

            {
                block9: {
                    if (i >= lineNumber) break block9;
                    li.next();
                    ** GOTO lbl7
                }
                if (i <= lineNumber) ** GOTO lbl7
                DiscoverStaticIPAddressRuleProvider.LOG.warning("Did not find line: " + lineNumber + " in file: " + model.getFile().getFileName());
            }
lbl41:
            // 2 sources

            LineIterator.closeQuietly((LineIterator)li);
            return false;
            LineIterator.closeQuietly((LineIterator)li);
            return false;
        }
    }

    private boolean isMavenFile(GraphContext context, FileLocationModel model) {
        if (!(model.getFile() instanceof XmlFileModel)) {
            return false;
        }
        ClassificationService cs = new ClassificationService(context);
        Iterator i$ = cs.getClassificationByName(model.getFile(), "Maven POM").iterator();
        if (i$.hasNext()) {
            ClassificationModel cm = (ClassificationModel)i$.next();
            return true;
        }
        return false;
    }

    private boolean isMavenVersionTag(GraphContext context, FileLocationModel model) {
        if (this.isMavenFile(context, model)) {
            Document doc = ((XmlFileModel)model.getFile()).asDocument();
            for (Element elm : JOOX.$((Document)doc).find("version")) {
                String text = StringUtils.trim((String)JOOX.$((Element)elm).text());
                if (!StringUtils.equals((String)text, (String)model.getSourceSnippit())) continue;
                return true;
            }
        }
        return false;
    }
}

