/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ast.java;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.windup.ast.java.ASTException;
import org.jboss.windup.ast.java.NoopWildcardImportResolver;
import org.jboss.windup.ast.java.ReferenceResolvingVisitor;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.ClassReference;

public class ASTProcessor {
    public static List<ClassReference> analyze(Set<String> libraryPaths, Set<String> sourcePaths, Path sourceFile) {
        return ASTProcessor.analyze(new NoopWildcardImportResolver(), libraryPaths, sourcePaths, sourceFile);
    }

    public static List<ClassReference> analyze(WildcardImportResolver importResolver, Set<String> libraryPaths, Set<String> sourcePaths, Path sourceFile) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setEnvironment(libraryPaths.toArray(new String[libraryPaths.size()]), sourcePaths.toArray(new String[sourcePaths.size()]), null, true);
        parser.setBindingsRecovery(false);
        parser.setResolveBindings(true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        String fileName = sourceFile.getFileName().toString();
        parser.setUnitName(fileName);
        try {
            parser.setSource(FileUtils.readFileToString((File)sourceFile.toFile()).toCharArray());
        }
        catch (IOException e) {
            throw new ASTException("Failed to get source for file: " + sourceFile.toString() + " due to: " + e.getMessage(), e);
        }
        parser.setKind(8);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        ReferenceResolvingVisitor visitor = new ReferenceResolvingVisitor(importResolver, cu, sourceFile.toString());
        cu.accept((ASTVisitor)visitor);
        return visitor.getJavaClassReferences();
    }
}

