/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.context.NexusIndexWriter;
import org.apache.maven.index.fs.Lock;
import org.apache.maven.index.fs.Locker;
import org.apache.maven.index.incremental.IncrementalHandler;
import org.apache.maven.index.updater.IndexDataReader;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdateSideEffect;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultIndexUpdater
implements IndexUpdater {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IncrementalHandler incrementalHandler;
    private final List<IndexUpdateSideEffect> sideEffects;

    protected Logger getLogger() {
        return this.logger;
    }

    @Inject
    public DefaultIndexUpdater(IncrementalHandler incrementalHandler, List<IndexUpdateSideEffect> sideEffects) {
        this.incrementalHandler = incrementalHandler;
        this.sideEffects = sideEffects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexUpdateResult fetchAndUpdateIndex(IndexUpdateRequest updateRequest) throws IOException {
        IndexUpdateResult result = new IndexUpdateResult();
        IndexingContext context = updateRequest.getIndexingContext();
        ResourceFetcher fetcher = null;
        if (!updateRequest.isOffline()) {
            fetcher = updateRequest.getResourceFetcher();
            if (fetcher == null) {
                throw new IOException("Update of the index without provided ResourceFetcher is impossible.");
            }
            fetcher.connect(context.getId(), context.getIndexUpdateUrl());
        }
        File cacheDir = updateRequest.getLocalIndexCacheDir();
        Locker locker = updateRequest.getLocker();
        Lock lock = locker != null && cacheDir != null ? locker.lock(cacheDir) : null;
        try {
            if (cacheDir != null) {
                LocalCacheIndexAdaptor cache = new LocalCacheIndexAdaptor(cacheDir, result);
                if (!updateRequest.isOffline()) {
                    cacheDir.mkdirs();
                    try {
                        if (this.fetchAndUpdateIndex(updateRequest, fetcher, cache).isSuccessful()) {
                            cache.commit();
                        }
                    }
                    finally {
                        fetcher.disconnect();
                    }
                }
                fetcher = cache.getFetcher();
            } else if (updateRequest.isOffline()) {
                throw new IllegalArgumentException("LocalIndexCacheDir can not be null in offline mode");
            }
            try {
                LuceneIndexAdaptor target;
                if (!updateRequest.isCacheOnly() && (result = this.fetchAndUpdateIndex(updateRequest, fetcher, target = new LuceneIndexAdaptor(updateRequest))).isSuccessful()) {
                    target.commit();
                }
            }
            finally {
                fetcher.disconnect();
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date loadIndexDirectory(IndexUpdateRequest updateRequest, ResourceFetcher fetcher, boolean merge, String remoteIndexFile) throws IOException {
        Date date;
        File indexDir = File.createTempFile(remoteIndexFile, ".dir");
        indexDir.delete();
        indexDir.mkdirs();
        FSDirectory directory = updateRequest.getFSDirectoryFactory().open(indexDir);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(fetcher.retrieve(remoteIndexFile));
            Date timestamp = null;
            if (!remoteIndexFile.endsWith(".gz")) {
                throw new IllegalArgumentException("The legacy format is no longer supported by this version of maven-indexer.");
            }
            timestamp = DefaultIndexUpdater.unpackIndexData(is, (Directory)directory, updateRequest.getIndexingContext());
            if (updateRequest.getDocumentFilter() != null) {
                DefaultIndexUpdater.filterDirectory((Directory)directory, updateRequest.getDocumentFilter());
            }
            if (merge) {
                updateRequest.getIndexingContext().merge((Directory)directory);
            } else {
                updateRequest.getIndexingContext().replace((Directory)directory);
            }
            if (this.sideEffects != null && this.sideEffects.size() > 0) {
                this.getLogger().info(IndexUpdateSideEffect.class.getName() + " extensions found: " + this.sideEffects.size());
                for (IndexUpdateSideEffect sideeffect : this.sideEffects) {
                    sideeffect.updateIndex((Directory)directory, updateRequest.getIndexingContext(), merge);
                }
            }
            date = timestamp;
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            if (directory != null) {
                directory.close();
            }
            try {
                FileUtils.deleteDirectory((File)indexDir);
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        IOUtil.close((InputStream)is);
        if (directory != null) {
            directory.close();
        }
        try {
            FileUtils.deleteDirectory((File)indexDir);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterDirectory(Directory directory, DocumentFilter filter) throws IOException {
        DirectoryReader r = null;
        NexusIndexWriter w = null;
        try {
            r = IndexReader.open((Directory)directory);
            w = new NexusIndexWriter(directory, new NexusAnalyzer(), false);
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)r);
            int numDocs = r.maxDoc();
            for (int i = 0; i < numDocs; ++i) {
                Document d;
                if (liveDocs != null && !liveDocs.get(i) || filter.accept(d = r.document(i))) continue;
                boolean success = w.tryDeleteDocument((IndexReader)r, i);
            }
            w.commit();
        }
        catch (Throwable throwable) {
            IndexUtils.close((IndexReader)r);
            IndexUtils.close(w);
            throw throwable;
        }
        IndexUtils.close((IndexReader)r);
        IndexUtils.close(w);
        w = null;
        try {
            w = new NexusIndexWriter(directory, new NexusAnalyzer(), false);
            w.forceMerge(4);
            w.commit();
        }
        finally {
            IndexUtils.close(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadIndexProperties(File indexDirectoryFile, String remoteIndexPropertiesName) {
        Properties properties;
        File indexProperties = new File(indexDirectoryFile, remoteIndexPropertiesName);
        FileInputStream fis = null;
        try {
            Properties properties2 = new Properties();
            fis = new FileInputStream(indexProperties);
            properties2.load(fis);
            properties = properties2;
        }
        catch (IOException e) {
            try {
                this.getLogger().debug("Unable to read remote properties stored locally", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
            IOUtil.close((InputStream)fis);
            return null;
        }
        IOUtil.close((InputStream)fis);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIndexProperties(File dir, String indexPropertiesName, Properties properties) throws IOException {
        File file = new File(dir, indexPropertiesName);
        if (properties != null) {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                properties.store(os, null);
            }
            finally {
                IOUtil.close((OutputStream)os);
            }
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties downloadIndexProperties(ResourceFetcher fetcher) throws IOException {
        InputStream fis = fetcher.retrieve("nexus-maven-repository-index.properties");
        try {
            Properties properties = new Properties();
            properties.load(fis);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOUtil.close((InputStream)fis);
        }
    }

    public Date getTimestamp(Properties properties, String key) {
        String indexTimestamp = properties.getProperty(key);
        if (indexTimestamp != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(indexTimestamp);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date unpackIndexData(InputStream is, Directory d, IndexingContext context) throws IOException {
        NexusIndexWriter w = new NexusIndexWriter(d, new NexusAnalyzer(), true);
        try {
            IndexDataReader dr = new IndexDataReader(is);
            IndexDataReader.IndexDataReadResult result = dr.readIndex(w, context);
            Date date = result.getTimestamp();
            return date;
        }
        finally {
            IndexUtils.close(w);
        }
    }

    private IndexUpdateResult fetchAndUpdateIndex(IndexUpdateRequest updateRequest, ResourceFetcher source, IndexAdaptor target) throws IOException {
        IndexUpdateResult result = new IndexUpdateResult();
        if (!updateRequest.isForceFullUpdate()) {
            Properties remoteProperties;
            Date updateTimestamp;
            Properties localProperties = target.getProperties();
            Object localTimestamp = null;
            if (localProperties != null) {
                localTimestamp = this.getTimestamp(localProperties, "nexus.index.timestamp");
            }
            if ((updateTimestamp = this.getTimestamp(remoteProperties = target.setProperties(source), "nexus.index.timestamp")) != null) {
                List<String> filenames = this.incrementalHandler.loadRemoteIncrementalUpdates(updateRequest, localProperties, remoteProperties);
                if (filenames != null) {
                    for (String filename : filenames) {
                        target.addIndexChunk(source, filename);
                    }
                    result.setTimestamp(updateTimestamp);
                    result.setSuccessful(true);
                    return result;
                }
            } else {
                updateTimestamp = this.getTimestamp(remoteProperties, "nexus.index.time");
            }
            if (localTimestamp != null && updateTimestamp != null && localTimestamp != null && !updateTimestamp.after((Date)localTimestamp)) {
                result.setSuccessful(true);
                return result;
            }
        } else {
            target.setProperties(source);
        }
        if (!updateRequest.isIncrementalOnly()) {
            Date timestamp = null;
            try {
                timestamp = target.setIndexFile(source, "nexus-maven-repository-index.gz");
                if (source instanceof LocalIndexCacheFetcher) {
                    for (String filename : ((LocalIndexCacheFetcher)source).getChunks()) {
                        target.addIndexChunk(source, filename);
                    }
                }
            }
            catch (IOException ex) {
                try {
                    timestamp = target.setIndexFile(source, "nexus-maven-repository-index.zip");
                }
                catch (IOException ex2) {
                    this.getLogger().error("Fallback to *.zip also failed: " + ex2);
                    throw ex;
                }
            }
            result.setTimestamp(timestamp);
            result.setSuccessful(true);
            result.setFullUpdate(true);
        }
        return result;
    }

    protected void cleanCacheDirectory(File dir) throws IOException {
        File[] members = dir.listFiles();
        if (members == null) {
            return;
        }
        for (File member : members) {
            if (".lock".equals(member.getName())) continue;
            FileUtils.forceDelete((File)member);
        }
    }

    static abstract class LocalIndexCacheFetcher
    extends FileFetcher {
        public LocalIndexCacheFetcher(File basedir) {
            super(basedir);
        }

        public abstract List<String> getChunks() throws IOException;
    }

    private class LocalCacheIndexAdaptor
    extends IndexAdaptor {
        private static final String CHUNKS_FILENAME = "chunks.lst";
        private static final String CHUNKS_FILE_ENCODING = "UTF-8";
        private final IndexUpdateResult result;
        private final ArrayList<String> newChunks;

        public LocalCacheIndexAdaptor(File dir, IndexUpdateResult result) {
            super(dir);
            this.newChunks = new ArrayList();
            this.result = result;
        }

        @Override
        public Properties getProperties() {
            if (this.properties == null) {
                this.properties = DefaultIndexUpdater.this.loadIndexProperties(this.dir, "nexus-maven-repository-index.properties");
            }
            return this.properties;
        }

        @Override
        public void storeProperties() throws IOException {
            DefaultIndexUpdater.this.storeIndexProperties(this.dir, "nexus-maven-repository-index.properties", this.properties);
        }

        @Override
        public Date getTimestamp() {
            Properties properties = this.getProperties();
            if (properties == null) {
                return null;
            }
            Date timestamp = DefaultIndexUpdater.this.getTimestamp(properties, "nexus.index.timestamp");
            if (timestamp == null) {
                timestamp = DefaultIndexUpdater.this.getTimestamp(properties, "nexus.index.time");
            }
            return timestamp;
        }

        @Override
        public void addIndexChunk(ResourceFetcher source, String filename) throws IOException {
            File chunk = new File(this.dir, filename);
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(source.retrieve(filename)), (File)chunk);
            this.newChunks.add(filename);
        }

        @Override
        public Date setIndexFile(ResourceFetcher source, String filename) throws IOException {
            DefaultIndexUpdater.this.cleanCacheDirectory(this.dir);
            this.result.setFullUpdate(true);
            File target = new File(this.dir, filename);
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(source.retrieve(filename)), (File)target);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws IOException {
            File chunksFile = new File(this.dir, CHUNKS_FILENAME);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(chunksFile, true));
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, CHUNKS_FILE_ENCODING);
            try {
                for (String filename : this.newChunks) {
                    w.write(filename + "\n");
                }
                ((Writer)w).flush();
            }
            finally {
                IOUtil.close((Writer)w);
                IOUtil.close((OutputStream)os);
            }
            super.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getChunks() throws IOException {
            ArrayList<String> chunks = new ArrayList<String>();
            File chunksFile = new File(this.dir, CHUNKS_FILENAME);
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(chunksFile), CHUNKS_FILE_ENCODING));
            try {
                String str;
                while ((str = r.readLine()) != null) {
                    chunks.add(str);
                }
            }
            finally {
                IOUtil.close((Reader)r);
            }
            return chunks;
        }

        public ResourceFetcher getFetcher() {
            return new LocalIndexCacheFetcher(this.dir){

                @Override
                public List<String> getChunks() throws IOException {
                    return LocalCacheIndexAdaptor.this.getChunks();
                }
            };
        }
    }

    private class LuceneIndexAdaptor
    extends IndexAdaptor {
        private final IndexUpdateRequest updateRequest;

        public LuceneIndexAdaptor(IndexUpdateRequest updateRequest) {
            super(updateRequest.getIndexingContext().getIndexDirectoryFile());
            this.updateRequest = updateRequest;
        }

        @Override
        public Properties getProperties() {
            if (this.properties == null) {
                this.properties = DefaultIndexUpdater.this.loadIndexProperties(this.dir, "nexus-maven-repository-index-updater.properties");
            }
            return this.properties;
        }

        @Override
        public void storeProperties() throws IOException {
            DefaultIndexUpdater.this.storeIndexProperties(this.dir, "nexus-maven-repository-index-updater.properties", this.properties);
        }

        @Override
        public Date getTimestamp() {
            return this.updateRequest.getIndexingContext().getTimestamp();
        }

        @Override
        public void addIndexChunk(ResourceFetcher source, String filename) throws IOException {
            DefaultIndexUpdater.this.loadIndexDirectory(this.updateRequest, source, true, filename);
        }

        @Override
        public Date setIndexFile(ResourceFetcher source, String filename) throws IOException {
            return DefaultIndexUpdater.this.loadIndexDirectory(this.updateRequest, source, false, filename);
        }

        @Override
        public void commit() throws IOException {
            super.commit();
            this.updateRequest.getIndexingContext().commit();
        }
    }

    private abstract class IndexAdaptor {
        protected final File dir;
        protected Properties properties;

        protected IndexAdaptor(File dir) {
            this.dir = dir;
        }

        public abstract Properties getProperties();

        public abstract void storeProperties() throws IOException;

        public abstract void addIndexChunk(ResourceFetcher var1, String var2) throws IOException;

        public abstract Date setIndexFile(ResourceFetcher var1, String var2) throws IOException;

        public Properties setProperties(ResourceFetcher source) throws IOException {
            this.properties = DefaultIndexUpdater.this.downloadIndexProperties(source);
            return this.properties;
        }

        public abstract Date getTimestamp();

        public void commit() throws IOException {
            this.storeProperties();
        }
    }

    public static class FileFetcher
    implements ResourceFetcher {
        private final File basedir;

        public FileFetcher(File basedir) {
            this.basedir = basedir;
        }

        @Override
        public void connect(String id, String url) throws IOException {
        }

        @Override
        public void disconnect() throws IOException {
        }

        public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
            FileUtils.copyFile((File)this.getFile(name), (File)targetFile);
        }

        @Override
        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            return new FileInputStream(this.getFile(name));
        }

        private File getFile(String name) {
            return new File(this.basedir, name);
        }
    }
}

