/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.PathUtil;

@Singleton
public class RuleProviderRegistryCache {
    private static final Logger LOG = Logger.getLogger(RuleProviderRegistryCache.class.getSimpleName());
    private static final long MAX_CACHE_AGE = 60000L;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private RuleLoader ruleLoader;
    private Set<Path> userRulesPaths = new LinkedHashSet<Path>();
    private RuleProviderRegistry cachedRegistry;
    private long cacheRefreshTime;

    public void addUserRulesPath(Path path) {
        this.userRulesPaths.add(path);
    }

    public Set<String> getAvailableTags() {
        HashSet<String> tags = new HashSet<String>();
        for (RuleProvider provider : this.getRuleProviderRegistry().getProviders()) {
            tags.addAll(provider.getMetadata().getTags());
        }
        return tags;
    }

    public Set<String> getAvailableSourceTechnologies() {
        HashSet<String> sourceOptions = new HashSet<String>();
        for (RuleProvider provider : this.getRuleProviderRegistry().getProviders()) {
            for (TechnologyReference technologyReference : provider.getMetadata().getSourceTechnologies()) {
                sourceOptions.add(technologyReference.getId());
            }
        }
        return sourceOptions;
    }

    public Set<String> getAvailableTargetTechnologies() {
        HashSet<String> targetOptions = new HashSet<String>();
        for (RuleProvider provider : this.getRuleProviderRegistry().getProviders()) {
            for (TechnologyReference technologyReference : provider.getMetadata().getTargetTechnologies()) {
                targetOptions.add(technologyReference.getId());
            }
        }
        return targetOptions;
    }

    public RuleProviderRegistry getRuleProviderRegistry() {
        if (this.cacheValid()) {
            return this.cachedRegistry;
        }
        this.cachedRegistry = null;
        try (GraphContext graphContext = this.graphContextFactory.create();){
            this.getRuleProviderRegistry(graphContext);
            graphContext.clear();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load rule information due to: " + e.getMessage(), e);
        }
        return this.cachedRegistry;
    }

    public RuleProviderRegistry getRuleProviderRegistry(GraphContext graphContext) {
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
        FileModel windupRulesPath = new FileService(graphContext).createByFilePath(PathUtil.getWindupRulesDir().toString());
        FileModel userRulesPath = new FileService(graphContext).createByFilePath(PathUtil.getUserRulesDir().toString());
        boolean pathAlreadyAdded = false;
        for (FileModel existingRulePath : configurationModel.getUserRulesPaths()) {
            if (!existingRulePath.equals(windupRulesPath)) continue;
            pathAlreadyAdded = true;
        }
        if (!pathAlreadyAdded) {
            configurationModel.addUserRulesPath(windupRulesPath);
            configurationModel.addUserRulesPath(userRulesPath);
        }
        for (Path additionalUserRulesPath : this.userRulesPaths) {
            FileModel additionalRulesFileModel = new FileService(graphContext).createByFilePath(additionalUserRulesPath.toString());
            configurationModel.addUserRulesPath(additionalRulesFileModel);
        }
        this.cachedRegistry = this.ruleLoader.loadConfiguration(graphContext, null);
        this.cacheRefreshTime = System.currentTimeMillis();
        return this.cachedRegistry;
    }

    private boolean cacheValid() {
        if (this.cachedRegistry == null) {
            return false;
        }
        long cacheAge = System.currentTimeMillis() - this.cacheRefreshTime;
        return cacheAge < 60000L;
    }
}

