/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.workers.FileSystemEventProcessor;
import org.xadisk.filesystem.workers.observers.EventDispatchListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemEventDelegator
implements Work {
    private final NativeXAFileSystem xaFileSystem;
    private final LinkedBlockingQueue<FileSystemStateChangeEvent> eventQueue;
    private final WorkManager workManager;
    private final CopyOnWriteArrayList<EndPointActivation> registeredActivations = new CopyOnWriteArrayList();
    private final int maximumConcurrentEventDeliveries;
    private final EventDispatchListener eventDispatchListener;
    private volatile boolean released = false;

    public FileSystemEventDelegator(NativeXAFileSystem xaFileSystem, int maximumConcurrentEventDeliveries) {
        this.xaFileSystem = xaFileSystem;
        this.eventQueue = xaFileSystem.getFileSystemEventQueue();
        this.workManager = xaFileSystem.getWorkManager();
        this.maximumConcurrentEventDeliveries = maximumConcurrentEventDeliveries;
        this.eventDispatchListener = new EventDispatchListener();
    }

    public boolean registerActivation(EndPointActivation activation) {
        if (this.registeredActivations.contains(activation)) {
            return false;
        }
        this.registeredActivations.add(activation);
        return true;
    }

    public void deRegisterActivation(EndPointActivation activation) {
        int registeredAt;
        MessageEndpointFactory mef = activation.getMessageEndpointFactory();
        if (mef instanceof RemoteMessageEndpointFactory && (registeredAt = this.registeredActivations.indexOf(activation)) != -1) {
            RemoteMessageEndpointFactory remoteMEF = (RemoteMessageEndpointFactory)this.registeredActivations.get(registeredAt).getMessageEndpointFactory();
            remoteMEF.shutdown();
        }
        this.registeredActivations.remove(activation);
    }

    public ArrayList<EndPointActivation> getAllActivations() {
        return new ArrayList<EndPointActivation>(this.registeredActivations);
    }

    public void run() {
        block5: while (true) {
            try {
                while (!this.released) {
                    if (this.eventDispatchListener.getOngoingConcurrentDeliveries() >= this.maximumConcurrentEventDeliveries) {
                        Thread.sleep(100L);
                        continue;
                    }
                    FileSystemStateChangeEvent event = this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    Iterator<EndPointActivation> activations = this.registeredActivations.iterator();
                    EndPointActivation interestedActivationPicked = null;
                    while (activations.hasNext()) {
                        EndPointActivation current = activations.next();
                        if (!current.getActivationSpecImpl().isEndpointInterestedIn(event)) continue;
                        interestedActivationPicked = current;
                        break;
                    }
                    try {
                        if (interestedActivationPicked == null) continue block5;
                        this.workManager.startWork((Work)new FileSystemEventProcessor(interestedActivationPicked.getMessageEndpointFactory(), event, this.xaFileSystem), Long.MAX_VALUE, null, (WorkListener)this.eventDispatchListener);
                        continue block5;
                    }
                    catch (WorkException we) {
                        this.eventQueue.put(event);
                    }
                }
                break;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                this.xaFileSystem.notifySystemFailure(t);
                break;
            }
        }
    }

    public void release() {
        this.released = true;
    }

    public ArrayList<FileSystemStateChangeEvent> retainOnlyInterestingEvents(ArrayList<FileSystemStateChangeEvent> fileStateChangeEventsToRaise) {
        ArrayList<FileSystemStateChangeEvent> eventsToRetain = new ArrayList<FileSystemStateChangeEvent>();
        block0: for (FileSystemStateChangeEvent event : fileStateChangeEventsToRaise) {
            for (EndPointActivation activation : this.registeredActivations) {
                if (!activation.getActivationSpecImpl().isEndpointInterestedIn(event)) continue;
                eventsToRetain.add(event);
                continue block0;
            }
        }
        return eventsToRetain;
    }
}

