/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.SizeAwaitMapStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeAwaitMap<K, V>
implements Map<K, V> {
    private EnvironmentImpl envImpl;
    private final HashMap<Integer, RepUtils.ExceptionAwareCountDownLatch> thresholdLatches;
    private final Map<K, V> map;
    private final StatGroup stats;
    private final LongStat nNoWaits;
    private final LongStat nRealWaits;
    private final LongStat nWaitTime;

    public SizeAwaitMap(EnvironmentImpl envImpl, Map<K, V> map) {
        this.envImpl = envImpl;
        this.thresholdLatches = new HashMap();
        this.map = map;
        this.stats = new StatGroup("SizeAwaitMap", "SizeAwaitMap statistics");
        this.nNoWaits = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_NO_WAITS);
        this.nRealWaits = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_REAL_WAITS);
        this.nWaitTime = new LongStat(this.stats, SizeAwaitMapStatDefinition.N_WAIT_TIME);
    }

    public StatGroup getStatistics() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sizeAwait(int thresholdSize, long timeout, TimeUnit unit) throws InterruptedException {
        assert (thresholdSize >= 0);
        RepUtils.ExceptionAwareCountDownLatch l = null;
        SizeAwaitMap sizeAwaitMap = this;
        synchronized (sizeAwaitMap) {
            int size = this.map.size();
            if (thresholdSize <= size) {
                this.nNoWaits.increment();
                return true;
            }
            l = this.thresholdLatches.get(thresholdSize);
            if (l == null) {
                l = new RepUtils.ExceptionAwareCountDownLatch(this.envImpl, 1);
                this.thresholdLatches.put(thresholdSize, l);
            }
        }
        this.nRealWaits.increment();
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = l.awaitOrException(timeout, unit);
            Object var10_10 = null;
            this.nWaitTime.add(System.currentTimeMillis() - startTime);
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.nWaitTime.add(System.currentTimeMillis() - startTime);
            throw throwable;
        }
    }

    synchronized int latchCount() {
        return this.thresholdLatches.size();
    }

    @Override
    public synchronized V put(K key, V value) {
        CountDownLatch l;
        V oldValue = this.map.put(key, value);
        if (oldValue == null && (l = (CountDownLatch)this.thresholdLatches.remove(this.map.size())) != null) {
            l.countDown();
        }
        return oldValue;
    }

    @Override
    public synchronized V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public synchronized void clear(Exception cause) {
        for (RepUtils.ExceptionAwareCountDownLatch l : this.thresholdLatches.values()) {
            l.releaseAwait(cause);
        }
        this.thresholdLatches.clear();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw EnvironmentFailureException.unexpectedState("putAll not supported");
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

