/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.tooling.ExecutionBuilder;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.ToolingXMLService;
import org.jboss.windup.tooling.WindupToolingProgressMonitor;
import org.jboss.windup.tooling.rules.RuleProviderRegistry;
import org.jboss.windup.tooling.rules.RuleProviderRegistryImpl;

public class ExecutionBuilderImpl
implements ExecutionBuilder {
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private ToolingXMLService toolingXMLService;
    @Inject
    private WindupProcessor processor;
    @Inject
    private Furnace furnace;
    private String windupHome;
    private WindupToolingProgressMonitor progressMonitor;
    private String input;
    private String output;
    private Set<String> ignorePathPatterns = new HashSet<String>();
    private Set<String> includePackagePrefixSet = new HashSet<String>();
    private Set<String> excludePackagePrefixSet = new HashSet<String>();
    private Set<String> userRulesPathSet = new HashSet<String>();
    private Map<String, Object> options = new HashMap<String, Object>();
    private String version;
    @Inject
    private RuleLoader ruleLoader;

    public void clear() throws RemoteException {
        this.windupHome = null;
        this.progressMonitor = null;
        this.input = null;
        this.output = null;
        this.ignorePathPatterns.clear();
        this.includePackagePrefixSet.clear();
        this.excludePackagePrefixSet.clear();
        this.userRulesPathSet.clear();
        this.options.clear();
    }

    public void terminate() throws RemoteException {
        this.furnace.stop();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().halt(1);
    }

    public void setWindupHome(String windupHome) throws RemoteException {
        this.windupHome = windupHome;
    }

    public void setInput(String input) throws RemoteException {
        this.input = input;
    }

    public void setOutput(String output) throws RemoteException {
        this.output = output;
    }

    public void ignore(String ignorePattern) throws RemoteException {
        this.ignorePathPatterns.add(ignorePattern);
    }

    public void includePackage(String packagePrefix) throws RemoteException {
        this.includePackagePrefixSet.add(packagePrefix);
    }

    public void includePackages(Collection<String> includePackagePrefixes) throws RemoteException {
        if (includePackagePrefixes != null) {
            this.includePackagePrefixSet.addAll(includePackagePrefixes);
        }
    }

    public void excludePackage(String packagePrefix) throws RemoteException {
        this.excludePackagePrefixSet.add(packagePrefix);
    }

    public void excludePackages(Collection<String> excludePackagePrefixes) throws RemoteException {
        if (excludePackagePrefixes != null) {
            this.excludePackagePrefixSet.addAll(excludePackagePrefixes);
        }
    }

    public void setProgressMonitor(WindupToolingProgressMonitor monitor) throws RemoteException {
        this.progressMonitor = monitor;
    }

    public void sourceOnlyMode() throws RemoteException {
        this.options.put("sourceMode", true);
    }

    public void skipReportGeneration() throws RemoteException {
        this.options.put("skipReports", true);
    }

    public void addUserRulesPath(String rulesPath) throws RemoteException {
        if (rulesPath == null) {
            return;
        }
        String pathString = Paths.get(rulesPath, new String[0]).normalize().toAbsolutePath().toString();
        this.userRulesPathSet.add(pathString);
    }

    public void addUserRulesPaths(Iterable<String> rulesPaths) throws RemoteException {
        if (rulesPaths == null) {
            return;
        }
        for (String rulesPath : rulesPaths) {
            this.addUserRulesPath(rulesPath);
        }
    }

    public void setOption(String name, Object value) throws RemoteException {
        this.options.put(name, value);
    }

    public String getVersion() throws RemoteException {
        return this.version;
    }

    public void setVersion(String version) throws RemoteException {
        this.version = version;
    }

    /*
     * Exception decompiling
     */
    public ExecutionResults execute() throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RuleProviderRegistry getRuleProviderRegistry(List<String> pathStrings) throws RemoteException {
        RuleProviderRegistryImpl ruleProviderRegistry = new RuleProviderRegistryImpl();
        List paths = pathStrings.stream().map(pathString -> Paths.get(pathString, new String[0])).collect(Collectors.toList());
        RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(paths, null);
        org.jboss.windup.config.metadata.RuleProviderRegistry registry = this.ruleLoader.loadConfiguration(ruleLoaderContext);
        ruleProviderRegistry.buildRuleProviders(registry);
        return ruleProviderRegistry;
    }

    private class WindupProgressLoggingHandler
    extends Handler {
        private final WindupToolingProgressMonitor monitor;

        public WindupProgressLoggingHandler(WindupToolingProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.monitor == null) {
                return;
            }
            try {
                this.monitor.logMessage(record);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

