/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling.rules;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.RuleUtils;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.tooling.rules.RuleImpl;
import org.jboss.windup.tooling.rules.RuleProvider;
import org.jboss.windup.tooling.rules.RuleProviderImpl;
import org.jboss.windup.tooling.rules.RuleProviderRegistry;
import org.jboss.windup.tooling.rules.Technology;
import org.jboss.windup.tooling.rules.TechnologyImpl;
import org.ocpsoft.rewrite.config.Rule;

public class RuleProviderRegistryImpl
implements RuleProviderRegistry {
    private static final long serialVersionUID = 1L;
    private List<RuleProvider> ruleProviders = new ArrayList<RuleProvider>();

    public List<RuleProvider> getRuleProviders() {
        return this.ruleProviders;
    }

    public void buildRuleProviders(org.jboss.windup.config.metadata.RuleProviderRegistry registry) {
        for (org.jboss.windup.config.RuleProvider provider : registry.getProviders()) {
            RuleProviderMetadata ruleProviderMetadata = provider.getMetadata();
            String providerID = ruleProviderMetadata.getID();
            String origin = ruleProviderMetadata.getOrigin();
            RuleProviderImpl ruleProvider = new RuleProviderImpl();
            ruleProvider.setProviderID(providerID);
            ruleProvider.setDateLoaded(new GregorianCalendar());
            ruleProvider.setDescription(ruleProviderMetadata.getDescription());
            ruleProvider.setOrigin(origin);
            this.ruleProviders.add(ruleProvider);
            this.setFileMetaData(ruleProvider);
            ruleProvider.setSources(this.technologyReferencesToTechnologyList(ruleProviderMetadata.getSourceTechnologies()));
            ruleProvider.setTargets(this.technologyReferencesToTechnologyList(ruleProviderMetadata.getTargetTechnologies()));
            String phase = MigrationRulesPhase.class.getSimpleName().toUpperCase();
            if (ruleProviderMetadata.getPhase() != null) {
                phase = ruleProviderMetadata.getPhase().getSimpleName().toUpperCase();
            }
            ruleProvider.setPhase(phase);
            ruleProvider.setRuleProviderType(this.getProviderType(origin));
            ArrayList<RuleImpl> rules = new ArrayList<RuleImpl>();
            for (Rule rule : registry.getRules(provider)) {
                String ruleID = rule.getId();
                String ruleString = RuleUtils.ruleToRuleContentsString((Rule)rule, (int)0);
                RuleImpl ruleCopy = new RuleImpl();
                ruleCopy.setRuleID(ruleID);
                ruleCopy.setRuleContents(ruleString);
                rules.add(ruleCopy);
            }
            ruleProvider.setRules(rules);
        }
    }

    private Set<Technology> technologyReferencesToTechnologyList(Collection<TechnologyReference> technologyReferences) {
        HashSet<Technology> results = new HashSet<Technology>();
        for (TechnologyReference technologyReference : technologyReferences) {
            TechnologyImpl technology = new TechnologyImpl();
            technology.setName(technologyReference.getId());
            String versionRange = technologyReference.getVersionRangeAsString();
            if (StringUtils.isNotBlank((String)versionRange)) {
                technology.setVersionRange(versionRange);
            }
            results.add(technology);
        }
        return results;
    }

    private void setFileMetaData(RuleProvider ruleProvider) {
        if (ruleProvider.getOrigin() == null) {
            return;
        }
        try {
            Path filePath;
            String filePathString = ruleProvider.getOrigin();
            if (filePathString.startsWith("file:")) {
                filePathString = filePathString.substring(5);
            }
            if (!Files.isRegularFile(filePath = Paths.get(filePathString, new String[0]), new LinkOption[0])) {
                return;
            }
            FileTime lastModifiedTime = Files.getLastModifiedTime(Paths.get(filePathString, new String[0]), new LinkOption[0]);
            GregorianCalendar lastModifiedCalendar = new GregorianCalendar();
            lastModifiedCalendar.setTimeInMillis(lastModifiedTime.toMillis());
            ruleProvider.setDateModified((Calendar)lastModifiedCalendar);
            ruleProvider.setOrigin(filePath.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private RuleProvider.RuleProviderType getProviderType(String origin) {
        if (origin == null) {
            return RuleProvider.RuleProviderType.JAVA;
        }
        if (origin.startsWith("file:") && origin.endsWith(".windup.xml")) {
            return RuleProvider.RuleProviderType.XML;
        }
        if (origin.startsWith("file:") && origin.endsWith(".windup.groovy")) {
            return RuleProvider.RuleProviderType.GROOVY;
        }
        return RuleProvider.RuleProviderType.JAVA;
    }
}

