/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.xml.condition.XmlFile;
import org.jboss.windup.rules.apps.xml.condition.XmlFileEvaluateXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileFunctionResolver;
import org.jboss.windup.rules.apps.xml.condition.XmlFileMatchesXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileParameterMatchCache;
import org.jboss.windup.rules.apps.xml.condition.XmlFileStartFrameXPathFunction;
import org.jboss.windup.rules.apps.xml.condition.XmlFileXPathTransformer;
import org.jboss.windup.rules.apps.xml.condition.validators.XmlFileValidator;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.model.XmlTypeReferenceModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.xml.NamespaceMapContext;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFileXpathValidator
implements XmlFileValidator {
    protected static final String WINDUP_NS_PREFIX = "windup";
    protected static final String WINDUP_NS_URI = "http://windup.jboss.org/windupv2functions";
    private static XPathFactory factory = XPathFactory.newInstance();
    private XPathExpression compiledXPath;
    private final XPath xpathEngine;
    private final XmlFileFunctionResolver xmlFileFunctionResolver;
    private XmlFile.XmlFileEvaluationStrategy evaluationStrategy;
    private String xpathResultMatch;
    private List<WindupVertexFrame> results = new ArrayList<WindupVertexFrame>();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private String xpathString;
    private static final Logger LOG = Logging.get(XmlFileXpathValidator.class);
    private RegexParameterizedPatternParser xpathPattern;

    public XmlFileXpathValidator() {
        this.namespaces.put(WINDUP_NS_PREFIX, WINDUP_NS_URI);
        this.xpathEngine = factory.newXPath();
        XPathFunctionResolver originalResolver = this.xpathEngine.getXPathFunctionResolver();
        this.xmlFileFunctionResolver = new XmlFileFunctionResolver(originalResolver);
        this.xpathEngine.setXPathFunctionResolver(this.xmlFileFunctionResolver);
    }

    public void setXpathString(String xpath) {
        this.xpathString = xpath;
        this.compiledXPath = null;
        if (xpath != null) {
            this.xpathPattern = new RegexParameterizedPatternParser(this.xpathString);
        }
    }

    @Override
    public boolean isValid(GraphRewrite event, EvaluationContext context, XmlFileModel model) {
        if (this.xpathString == null) {
            return true;
        }
        String xpathStringWithParameterFunctions = XmlFileXPathTransformer.transformXPath(this.xpathString);
        LOG.fine("XmlFile compiled: " + this.xpathString + " to " + xpathStringWithParameterFunctions);
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document document = xmlFileService.loadDocumentQuiet(event, context, model);
        if (document != null) {
            ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
            XmlFileParameterMatchCache paramMatchCache = new XmlFileParameterMatchCache();
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "startFrame", new XmlFileStartFrameXPathFunction(paramMatchCache));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "evaluate", new XmlFileEvaluateXPathFunction(this.evaluationStrategy));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "matches", new XmlFileMatchesXPathFunction(context, store, paramMatchCache, event));
            this.xmlFileFunctionResolver.registerFunction(WINDUP_NS_URI, "persist", new XmlFilePersistXPathFunction(event, context, model, this.evaluationStrategy, store, paramMatchCache, this.results));
            if (this.compiledXPath == null) {
                NamespaceMapContext nsContext = new NamespaceMapContext(this.namespaces);
                this.xpathEngine.setNamespaceContext((NamespaceContext)nsContext);
                try {
                    this.compiledXPath = this.xpathEngine.compile(xpathStringWithParameterFunctions);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null && e.getCause() != null && e.getCause().getMessage() != null) {
                        message = e.getCause().getMessage();
                    }
                    LOG.severe("Condition: " + this + " failed to run, as the following xpath was uncompilable: " + this.xpathString + " (compiled contents: " + xpathStringWithParameterFunctions + ") due to: " + message);
                    return false;
                }
            }
            XmlUtil.xpathNodeList((Node)document, (XPathExpression)this.compiledXPath);
            this.evaluationStrategy.modelSubmissionRejected();
        }
        return !this.results.isEmpty();
    }

    public List<WindupVertexFrame> getAndClearResultLocations() {
        List<WindupVertexFrame> output = this.results;
        this.results = new ArrayList<WindupVertexFrame>();
        return output;
    }

    public void setXpathResult(String xpathResult) {
        this.xpathResultMatch = xpathResult;
    }

    public String getXpathString() {
        return this.xpathString;
    }

    public XPathExpression getXpathExpression() {
        return this.compiledXPath;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.xpathPattern != null) {
            this.xpathPattern.setParameterStore(store);
        }
    }

    public Collection<? extends String> getRequiredParamaterNames() {
        if (this.xpathPattern != null) {
            return this.xpathPattern.getRequiredParameterNames();
        }
        return Collections.emptyList();
    }

    public void addNamespace(String prefix, String url) {
        this.namespaces.put(prefix, url);
    }

    public void setEvaluationStrategy(XmlFile.XmlFileEvaluationStrategy evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy;
    }

    final class XmlFilePersistXPathFunction
    implements XPathFunction {
        private final GraphRewrite event;
        private final EvaluationContext context;
        private final XmlFileModel xml;
        private final XmlFile.XmlFileEvaluationStrategy evaluationStrategy;
        private final ParameterStore store;
        private final XmlFileParameterMatchCache paramMatchCache;
        private final List<WindupVertexFrame> resultLocations;

        XmlFilePersistXPathFunction(GraphRewrite event, EvaluationContext context, XmlFileModel xml, XmlFile.XmlFileEvaluationStrategy evaluationStrategy, ParameterStore store, XmlFileParameterMatchCache paramMatchCache, List<WindupVertexFrame> resultLocations) {
            this.event = event;
            this.context = context;
            this.xml = xml;
            this.evaluationStrategy = evaluationStrategy;
            this.store = store;
            this.paramMatchCache = paramMatchCache;
            this.resultLocations = resultLocations;
        }

        public Object evaluate(List args) throws XPathFunctionException {
            int frameIdx = ((Double)args.get(0)).intValue();
            NodeList arg1 = (NodeList)args.get(1);
            String nodeText = XmlUtil.nodeListToString((NodeList)arg1);
            LOG.fine("persist(" + frameIdx + ", " + nodeText + ")");
            for (int i = 0; i < arg1.getLength(); ++i) {
                Node node = arg1.item(i);
                if (XmlFileXpathValidator.this.xpathResultMatch != null && !node.toString().matches(XmlFileXpathValidator.this.xpathResultMatch)) continue;
                int lineNumber = (Integer)node.getUserData("ln");
                int columnNumber = (Integer)node.getUserData("cn");
                GraphService fileLocationService = new GraphService(this.event.getGraphContext(), XmlTypeReferenceModel.class);
                XmlTypeReferenceModel fileLocation = (XmlTypeReferenceModel)fileLocationService.create();
                String sourceSnippit = XmlUtil.nodeToString((Node)node);
                fileLocation.setSourceSnippit(sourceSnippit);
                fileLocation.setLineNumber(lineNumber);
                fileLocation.setColumnNumber(columnNumber);
                fileLocation.setLength(node.toString().length());
                fileLocation.setFile(this.xml);
                fileLocation.setXpath(XmlFileXpathValidator.this.xpathString);
                GraphService metaModelService = new GraphService(this.event.getGraphContext(), NamespaceMetaModel.class);
                for (Map.Entry entry : XmlFileXpathValidator.this.namespaces.entrySet()) {
                    NamespaceMetaModel metaModel = (NamespaceMetaModel)metaModelService.create();
                    metaModel.setSchemaLocation((String)entry.getKey());
                    metaModel.setSchemaLocation((String)entry.getValue());
                    metaModel.addXmlResource(this.xml);
                    fileLocation.addNamespace(metaModel);
                }
                this.resultLocations.add((WindupVertexFrame)fileLocation);
                this.evaluationStrategy.modelSubmissionRejected();
                this.evaluationStrategy.modelMatched();
                for (Map.Entry<Object, Object> entry : this.paramMatchCache.getVariables().entrySet()) {
                    String value;
                    Parameter param = this.store.get((String)entry.getKey());
                    if (this.evaluationStrategy.submitValue(param, value = (String)entry.getValue())) continue;
                    this.evaluationStrategy.modelSubmissionRejected();
                    return false;
                }
                this.evaluationStrategy.modelSubmitted((WindupVertexFrame)fileLocation);
                this.evaluationStrategy.modelMatched();
            }
            return true;
        }
    }
}

