/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.forge.furnace.ContainerStatus;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonCompatibilityStrategy;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.LoggingRepair;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonRegistryImpl;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.impl.addons.DirtyCheckableRepository;
import org.jboss.forge.furnace.impl.addons.DirtyChecker;
import org.jboss.forge.furnace.impl.addons.ImmutableAddonRepository;
import org.jboss.forge.furnace.impl.addons.VersionDirtyChecker;
import org.jboss.forge.furnace.impl.lock.LockManagerImpl;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.AddonCompatibilityStrategies;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.modules.Module;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.StreamModuleLogger;

public class FurnaceImpl
implements Furnace {
    public static final String FURNACE_ADDON_COMPATIBILITY_PROPERTY = "furnace.addons.compatibility";
    public static final String FURNACE_LOGGING_LEAK_CLASSLOADERS_PROPERTY = "furnace.logging.leak";
    public static final String FURNACE_DEBUG_PROPERTY = "furnace.debug";
    public static final String TEST_MODE_PROPERTY = "furnace.test.mode";
    private static Logger logger = Logger.getLogger(FurnaceImpl.class.getName());
    private volatile boolean alive = false;
    private volatile ContainerStatus status = ContainerStatus.STOPPED;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean serverMode = true;
    private AddonLifecycleManager manager;
    private final List<ContainerLifecycleListener> registeredListeners = new ArrayList<ContainerLifecycleListener>();
    private final List<ListenerRegistration<ContainerLifecycleListener>> loadedListenerRegistrations = new ArrayList<ListenerRegistration<ContainerLifecycleListener>>();
    private ClassLoader loader;
    private final Set<RepositoryEntry> repositories = new HashSet<RepositoryEntry>();
    private final LockManager lock = new LockManagerImpl();
    private String[] args;
    private int registryCount = 0;
    boolean firedAfterStart = false;
    private AddonCompatibilityStrategy addonCompatibilityStrategy = AddonCompatibilityStrategies.STRICT;

    public FurnaceImpl() {
        String addonCompatibilityValue;
        if (!AddonRepositoryImpl.hasRuntimeAPIVersion()) {
            logger.warning("Could not detect Furnace runtime version - loading all addons, but failures may occur if versions are not compatible.");
        }
        if (!Strings.isNullOrEmpty((String)(addonCompatibilityValue = System.getProperty(FURNACE_ADDON_COMPATIBILITY_PROPERTY)))) {
            AddonCompatibilityStrategies strategy = null;
            try {
                strategy = AddonCompatibilityStrategies.valueOf((String)addonCompatibilityValue);
            }
            catch (IllegalArgumentException iae) {
                try {
                    strategy = (AddonCompatibilityStrategy)Class.forName(addonCompatibilityValue).newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error loading [" + addonCompatibilityValue + "] defined by system property `" + FURNACE_ADDON_COMPATIBILITY_PROPERTY + "` ", e);
                }
            }
            if (strategy == null) {
                logger.warning("'" + addonCompatibilityValue + "' is not a valid value for the '" + FURNACE_ADDON_COMPATIBILITY_PROPERTY + "' property. Possible values are: " + Arrays.toString(AddonCompatibilityStrategies.values()) + " or a fully qualified class name. Assuming default value.");
            } else {
                this.setAddonCompatibilityStrategy((AddonCompatibilityStrategy)strategy);
            }
        }
        if (!Boolean.getBoolean(FURNACE_LOGGING_LEAK_CLASSLOADERS_PROPERTY)) {
            LoggingRepair.init();
        }
        if (Boolean.getBoolean(FURNACE_DEBUG_PROPERTY)) {
            this.enableLogging();
        }
    }

    public LockManager getLockManager() {
        return this.lock;
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.loader;
    }

    public Furnace enableLogging() {
        this.assertNotAlive();
        Module.setModuleLogger((ModuleLogger)new StreamModuleLogger(System.err));
        return this;
    }

    public Future<Furnace> startAsync() {
        return this.startAsync(FurnaceImpl.class.getClassLoader());
    }

    public Future<Furnace> startAsync(final ClassLoader loader) {
        return this.executor.submit(new Callable<Furnace>(){

            @Override
            public Furnace call() throws Exception {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("Furnace Container " + FurnaceImpl.this);
                        FurnaceImpl.this.start(loader);
                    }
                };
                thread.start();
                while (!ContainerStatus.STARTED.equals((Object)FurnaceImpl.this.getStatus())) {
                    Thread.sleep(25L);
                }
                return FurnaceImpl.this;
            }
        });
    }

    public void start() {
        this.start(FurnaceImpl.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClassLoader loader) {
        logger.log(Level.INFO, "Furnace [" + this.getVersion() + "] starting.");
        this.assertNotAlive();
        this.alive = true;
        this.loader = loader;
        for (ContainerLifecycleListener listener : ServiceLoader.load(ContainerLifecycleListener.class, loader)) {
            ListenerRegistration<ContainerLifecycleListener> registration = this.addContainerLifecycleListener(listener);
            this.loadedListenerRegistrations.add(registration);
        }
        this.fireBeforeContainerStartedEvent();
        try {
            this.getAddonRegistry(new AddonRepository[0]);
            do {
                this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        boolean dirty = false;
                        if (!FurnaceImpl.this.getLifecycleManager().isStartingAddons()) {
                            for (RepositoryEntry entry : FurnaceImpl.this.repositories) {
                                DirtyChecker dirtyChecker = entry.getDirtyChecker();
                                if (dirtyChecker.isDirty()) {
                                    logger.log(Level.FINE, "Detected changes in repository [" + entry.getRepository() + "].");
                                    dirty = true;
                                }
                                dirtyChecker.resetDirtyStatus();
                            }
                            if (dirty) {
                                FurnaceImpl.this.reloadConfiguration();
                            }
                        }
                        FurnaceImpl.this.status = ContainerStatus.STARTED;
                        if (!FurnaceImpl.this.firedAfterStart) {
                            FurnaceImpl.this.fireAfterContainerStartedEvent();
                            FurnaceImpl.this.firedAfterStart = true;
                        }
                        return null;
                    }
                });
                Thread.sleep(100L);
            } while (this.isAlive() && this.serverMode);
            while (this.isAlive() && this.getLifecycleManager().isStartingAddons()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occurred.", e);
        }
        finally {
            this.fireBeforeContainerStoppedEvent();
            this.status = ContainerStatus.STOPPED;
            this.getLifecycleManager().stopAll();
        }
        this.fireAfterContainerStoppedEvent();
        this.cleanup();
    }

    public Furnace stop() {
        this.alive = false;
        return this;
    }

    public void setArgs(String[] args) {
        this.assertNotAlive();
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public Furnace setServerMode(boolean server) {
        this.assertNotAlive();
        this.serverMode = server;
        return this;
    }

    public AddonRegistry getAddonRegistry(final AddonRepository ... repositories) {
        this.assertIsAlive();
        AddonRegistry result = this.getLifecycleManager().findView(repositories);
        if (result == null) {
            result = (AddonRegistry)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<AddonRegistry>(){

                @Override
                public AddonRegistry call() throws Exception {
                    AddonRegistry registry = FurnaceImpl.this.getLifecycleManager().findView(repositories);
                    if (registry == null) {
                        if (repositories == null || repositories.length == 0) {
                            String name = "ROOT_" + UUID.randomUUID().toString();
                            registry = new AddonRegistryImpl(FurnaceImpl.this.lock, FurnaceImpl.this.getLifecycleManager(), FurnaceImpl.this.getRepositories(), name);
                        } else {
                            String name = String.valueOf(FurnaceImpl.this.registryCount++ + "_" + UUID.randomUUID().toString());
                            registry = new AddonRegistryImpl(FurnaceImpl.this.lock, FurnaceImpl.this.getLifecycleManager(), Arrays.asList(repositories), name);
                        }
                        FurnaceImpl.this.getLifecycleManager().addView((AddonView)registry);
                        FurnaceImpl.this.getLifecycleManager().forceUpdate();
                    }
                    return registry;
                }
            });
        }
        return result;
    }

    public void disposeAddonView(AddonView view) {
        this.assertIsAlive();
        if (this.getAddonRegistry(new AddonRepository[0]).equals(view)) {
            throw new IllegalArgumentException("Cannot dispose the root AddonRegistry. Call .stop() instead.");
        }
        this.getLifecycleManager().removeView(view);
        this.getLifecycleManager().forceUpdate();
    }

    public Version getVersion() {
        return AddonRepositoryImpl.getRuntimeAPIVersion();
    }

    public ListenerRegistration<ContainerLifecycleListener> addContainerLifecycleListener(final ContainerLifecycleListener listener) {
        this.registeredListeners.add(listener);
        return new ListenerRegistration<ContainerLifecycleListener>(){

            public ContainerLifecycleListener removeListener() {
                FurnaceImpl.this.registeredListeners.remove(listener);
                return listener;
            }
        };
    }

    public List<AddonRepository> getRepositories() {
        return this.repositories.stream().map(RepositoryEntry::getRepository).collect(Collectors.toList());
    }

    public AddonRepository addRepository(AddonRepositoryMode mode, File directory) {
        Assert.notNull((Object)mode, (String)"Addon repository mode must not be null.");
        Assert.notNull((Object)directory, (String)"Addon repository directory must not be null.");
        Object repository = AddonRepositoryImpl.forDirectory(this, directory);
        if (mode.isImmutable()) {
            repository = new ImmutableAddonRepository((AddonRepository)repository);
        }
        return this.addRepository((AddonRepository)repository);
    }

    public AddonRepository addRepository(final AddonRepository repository) {
        Assert.notNull((Object)repository, (String)"Addon repository must not be null.");
        DirtyChecker dirtyChecker = repository instanceof DirtyCheckableRepository ? ((DirtyCheckableRepository)repository).createDirtyChecker() : new VersionDirtyChecker(() -> ((AddonRepository)repository).getVersion());
        final RepositoryEntry newEntry = new RepositoryEntry(repository, dirtyChecker);
        for (RepositoryEntry entry : this.repositories) {
            if (!entry.equals(newEntry)) continue;
            return entry.getRepository();
        }
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (FurnaceImpl.this.isAlive()) {
                    AddonRegistry registry = FurnaceImpl.this.getAddonRegistry(new AddonRepository[0]);
                    ((AddonRegistryImpl)registry).addRepository(repository);
                }
                FurnaceImpl.this.repositories.add(newEntry);
                return null;
            }
        });
        return repository;
    }

    public void assertIsAlive() {
        if (!this.isAlive()) {
            throw new IllegalStateException("Cannot access this method until Furnace is running. Call .start() or .startAsync() first.");
        }
    }

    public void assertNotAlive() {
        if (this.isAlive()) {
            throw new IllegalStateException("Cannot modify a running Furnace instance. Call .stop() first.");
        }
    }

    public ContainerStatus getStatus() {
        return (ContainerStatus)this.lock.performLocked(LockMode.READ, (Callable)new Callable<ContainerStatus>(){

            @Override
            public ContainerStatus call() throws Exception {
                if (!FurnaceImpl.this.isAlive()) {
                    return ContainerStatus.STOPPED;
                }
                boolean startingAddons = FurnaceImpl.this.getLifecycleManager().isStartingAddons();
                return startingAddons ? ContainerStatus.STARTING : FurnaceImpl.this.status;
            }
        });
    }

    public List<ContainerLifecycleListener> getRegisteredListeners() {
        return Collections.unmodifiableList(this.registeredListeners);
    }

    public AddonLifecycleManager getAddonLifecycleManager() {
        return this.getLifecycleManager();
    }

    public String toString() {
        return this.getLifecycleManager().toString();
    }

    public boolean isTestMode() {
        return Boolean.getBoolean(TEST_MODE_PROPERTY);
    }

    public void setAddonCompatibilityStrategy(final AddonCompatibilityStrategy strategy) {
        Assert.notNull((Object)strategy, (String)"AddonCompatibilityStrategy cannot be null");
        if (this.isAlive()) {
            this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FurnaceImpl.this.addonCompatibilityStrategy = strategy;
                    FurnaceImpl.this.reloadConfiguration();
                    return null;
                }
            });
        } else {
            this.addonCompatibilityStrategy = strategy;
        }
    }

    public AddonCompatibilityStrategy getAddonCompatibilityStrategy() {
        return this.addonCompatibilityStrategy;
    }

    private AddonLifecycleManager getLifecycleManager() {
        if (this.manager == null) {
            this.manager = new AddonLifecycleManager(this);
        }
        return this.manager;
    }

    private boolean isAlive() {
        return this.alive;
    }

    private void reloadConfiguration() {
        if (this.status.isStarted()) {
            this.status = ContainerStatus.RELOADING;
        }
        try {
            this.fireBeforeConfigurationScanEvent();
            this.getLifecycleManager().forceUpdate();
            this.fireAfterConfigurationScanEvent();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occurred.", e);
        }
        if (this.status.isReloading()) {
            this.status = ContainerStatus.STARTED;
        }
    }

    private void cleanup() {
        for (ListenerRegistration<ContainerLifecycleListener> registation : this.loadedListenerRegistrations) {
            registation.removeListener();
        }
        this.registeredListeners.clear();
        this.loader = null;
        this.manager.dispose();
        this.manager = null;
        for (RepositoryEntry entry : this.repositories) {
            try {
                entry.getDirtyChecker().close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error occurred.", e);
            }
        }
        this.repositories.clear();
        this.executor.shutdownNow();
        this.firedAfterStart = false;
    }

    private void fireBeforeConfigurationScanEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeConfigurationScan((Furnace)this);
        }
    }

    private void fireAfterConfigurationScanEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.afterConfigurationScan((Furnace)this);
        }
    }

    private void fireBeforeContainerStartedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeStart((Furnace)this);
        }
    }

    private void fireBeforeContainerStoppedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeStop((Furnace)this);
        }
    }

    private void fireAfterContainerStartedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.afterStart((Furnace)this);
        }
    }

    private void fireAfterContainerStoppedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.afterStop((Furnace)this);
        }
    }

    private static class RepositoryEntry {
        private final AddonRepository repository;
        private final DirtyChecker dirtyChecker;

        public RepositoryEntry(AddonRepository repository, DirtyChecker dirtyChecker) {
            this.repository = repository;
            this.dirtyChecker = dirtyChecker;
        }

        public AddonRepository getRepository() {
            return this.repository;
        }

        public DirtyChecker getDirtyChecker() {
            return this.dirtyChecker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryEntry that = (RepositoryEntry)o;
            return this.repository.getRootDirectory().equals(that.repository.getRootDirectory());
        }

        public int hashCode() {
            return this.repository.hashCode();
        }
    }
}

