/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonCompatibilityStrategy;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AbstractFileSystemAddonRepository;
import org.jboss.forge.furnace.impl.addons.DirtyChecker;
import org.jboss.forge.furnace.impl.addons.MutableAddonRepositoryStateStrategy;
import org.jboss.forge.furnace.impl.addons.VersionDirtyChecker;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.parser.xml.XMLParserException;

public final class AddonRepositoryStateStrategyImpl
extends AbstractFileSystemAddonRepository
implements MutableAddonRepositoryStateStrategy {
    private static final Logger logger = Logger.getLogger(AddonRepositoryStateStrategyImpl.class.getName());
    private static final String ATTR_API_VERSION = "api-version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VERSION = "version";
    private static final String REGISTRY_DESCRIPTOR_NAME = "installed.xml";
    private final Furnace furnace;
    private int version = 1;

    public AddonRepositoryStateStrategyImpl(Furnace furnace, File addonDir) {
        super(furnace.getLockManager(), addonDir);
        this.furnace = furnace;
    }

    @Override
    public boolean disable(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (addon == null) {
                    throw new RuntimeException("Addon must not be null");
                }
                File registryFile = AddonRepositoryStateStrategyImpl.this.getRepositoryRegistryFile();
                if (registryFile.exists()) {
                    try {
                        Node installed = AddonRepositoryStateStrategyImpl.this.getXmlRoot(registryFile);
                        Node child = installed.getSingle("addon@name=" + addon.getName() + "&" + AddonRepositoryStateStrategyImpl.ATTR_VERSION + "=" + addon.getVersion());
                        installed.removeChild(child);
                        AddonRepositoryStateStrategyImpl.this.saveRegistryFile(installed);
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not modify [" + registryFile.getAbsolutePath() + "] - ", e);
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean enable(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (addon == null) {
                    throw new RuntimeException("AddonId must not be null");
                }
                File registryFile = AddonRepositoryStateStrategyImpl.this.getRepositoryRegistryFile();
                try {
                    Node installed = AddonRepositoryStateStrategyImpl.this.getXmlRoot(registryFile);
                    installed.getOrCreate("addon@name=" + (addon.getName() == null ? "" : addon.getName()) + "&" + AddonRepositoryStateStrategyImpl.ATTR_VERSION + "=" + addon.getVersion()).attribute(AddonRepositoryStateStrategyImpl.ATTR_API_VERSION, (Object)(addon.getApiVersion() == null ? "" : addon.getApiVersion()));
                    AddonRepositoryStateStrategyImpl.this.saveRegistryFile(installed);
                    return true;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not read [" + registryFile.getAbsolutePath() + "] - ", e);
                }
            }
        });
    }

    private File getRepositoryRegistryFile() {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File registryFile = new File(AddonRepositoryStateStrategyImpl.this.getRootDirectory(), AddonRepositoryStateStrategyImpl.REGISTRY_DESCRIPTOR_NAME);
                try {
                    if (!registryFile.exists()) {
                        Files.write(registryFile.toPath(), "<installed/>".getBytes(), StandardOpenOption.CREATE_NEW);
                    }
                    return registryFile;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing addon registry file [" + registryFile + "]", e);
                }
            }
        });
    }

    @Override
    public boolean isEnabled(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AddonRepositoryStateStrategyImpl.this.listEnabled().contains(addon);
            }
        });
    }

    @Override
    public List<AddonId> listEnabled() {
        final AddonCompatibilityStrategy strategy = this.furnace.getAddonCompatibilityStrategy();
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<AddonId>>(){

            @Override
            public List<AddonId> call() throws Exception {
                List<AddonId> list = AddonRepositoryStateStrategyImpl.this.listAll();
                ArrayList<AddonId> result = new ArrayList<AddonId>();
                for (AddonId entry : list) {
                    if (!strategy.isCompatible(AddonRepositoryStateStrategyImpl.this.furnace, entry)) continue;
                    result.add(entry);
                }
                return result;
            }
        });
    }

    @Override
    public List<AddonId> listEnabledCompatibleWithVersion(final Version version) {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<AddonId>>(){

            @Override
            public List<AddonId> call() throws Exception {
                List<AddonId> list = AddonRepositoryStateStrategyImpl.this.listAll();
                ArrayList<AddonId> result = new ArrayList<AddonId>();
                for (AddonId entry : list) {
                    if (version != null && entry.getApiVersion() != null && !Versions.isApiCompatible((Version)version, (Version)entry.getApiVersion())) continue;
                    result.add(entry);
                }
                return result;
            }
        });
    }

    @Override
    public List<AddonId> listAll() {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<AddonId>>(){

            @Override
            public List<AddonId> call() throws Exception {
                ArrayList<AddonId> result = new ArrayList<AddonId>();
                File registryFile = AddonRepositoryStateStrategyImpl.this.getRepositoryRegistryFile();
                try {
                    Node installed = AddonRepositoryStateStrategyImpl.this.getXmlRoot(registryFile);
                    if (installed == null) {
                        return Collections.emptyList();
                    }
                    List list = installed.get("addon");
                    for (Node addon : list) {
                        AddonId entry = AddonId.from((String)addon.getAttribute(AddonRepositoryStateStrategyImpl.ATTR_NAME), (String)addon.getAttribute(AddonRepositoryStateStrategyImpl.ATTR_VERSION), (String)addon.getAttribute(AddonRepositoryStateStrategyImpl.ATTR_API_VERSION));
                        result.add(entry);
                    }
                }
                catch (XMLParserException e) {
                    throw new RuntimeException("Invalid syntax in [" + registryFile.getAbsolutePath() + "] - Please delete this file and restart Furnace", e);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result;
            }
        });
    }

    private Node getXmlRoot(File registryFile) throws FileNotFoundException, InterruptedException {
        Node installed = null;
        while (installed == null) {
            try {
                installed = XMLParser.parse((File)registryFile);
            }
            catch (XMLParserException e) {
                logger.log(Level.WARNING, "Error occurred while parsing [" + registryFile + "]", e);
            }
        }
        return installed;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private void saveRegistryFile(Node installed) throws FileNotFoundException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(this.getRepositoryRegistryFile());
            this.incrementVersion();
            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)outStream);
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(outStream);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)outStream);
    }

    private void incrementVersion() {
        ++this.version;
    }

    @Override
    public DirtyChecker createDirtyChecker() {
        return new VersionDirtyChecker(this::getVersion);
    }
}

