/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.model.stats;

import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.BackFilterPipe;
import com.tinkerpop.pipes.transform.OutPipe;
import com.tinkerpop.pipes.util.Pipeline;
import com.tinkerpop.pipes.util.StartPipe;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.model.BelongsToProject;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateEntityModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateMappingFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateSessionFactoryModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.model.JPAPersistenceUnitModel;
import org.jboss.windup.rules.apps.javaee.model.JaxRSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxWSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsConnectionFactoryModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationType;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.rules.apps.javaee.model.stats.GeneralStatsItemModel;
import org.jboss.windup.rules.apps.javaee.model.stats.TechnologiesStatsModel;
import org.jboss.windup.rules.apps.javaee.model.stats.TechnologyKeyValuePairModel;
import org.jboss.windup.rules.apps.javaee.service.TechnologyKeyValuePairModelService;
import org.jboss.windup.util.Logging;

public class TechnologiesStatsService
extends GraphService<TechnologiesStatsModel> {
    private static final Logger LOG = Logging.get(TechnologiesStatsService.class);
    private TechnologyKeyValuePairModelService technologyKeyValuePairModelService;

    public TechnologiesStatsService(GraphContext context) {
        super(context, TechnologiesStatsModel.class);
        this.technologyKeyValuePairModelService = new TechnologyKeyValuePairModelService(context);
    }

    protected void setCountFilesByType(TechnologiesStatsModel stats, Map<String, Integer> suffixToCount) {
        if (suffixToCount == null || suffixToCount.isEmpty()) {
            return;
        }
        suffixToCount.entrySet().forEach(entry -> {
            TechnologyKeyValuePairModel suffixUsage = ((TechnologyKeyValuePairModel)this.technologyKeyValuePairModelService.create()).setName((String)entry.getKey()).setValue((Integer)entry.getValue());
            stats.addFileType(suffixUsage);
        });
    }

    protected void setTechnologiesUsage(TechnologiesStatsModel stats, Map<String, Integer> technologyUsage) {
        if (technologyUsage == null || technologyUsage.isEmpty()) {
            return;
        }
        technologyUsage.entrySet().forEach(entry -> {
            TechnologyKeyValuePairModel currentTechnology = ((TechnologyKeyValuePairModel)this.technologyKeyValuePairModelService.create()).setName((String)entry.getKey()).setValue((Integer)entry.getValue());
            stats.addTechnology(currentTechnology);
        });
    }

    public TechnologiesStatsModel computeStats(Map<String, Integer> suffixToCount, Map<String, Integer> technologyUsage) {
        TechnologiesStatsModel stats = (TechnologiesStatsModel)this.create();
        stats.setComputed(new Date());
        this.setCountFilesByType(stats, suffixToCount);
        this.setTechnologiesUsage(stats, technologyUsage);
        this.commit();
        return stats;
    }

    public Map<ProjectModel, Map<String, Integer>> countTechnologiesUsage() {
        HashMap<String, Map<ProjectModel, Integer>> technologyUsage = new HashMap<String, Map<ProjectModel, Integer>>();
        technologyUsage.put("stats.services.ejb.stateless", this.countByType(EjbSessionBeanModel.class, "sessionType", (Serializable)((Object)"stateless")));
        technologyUsage.put("stats.services.ejb.stateful", this.countByType(EjbSessionBeanModel.class, "sessionType", (Serializable)((Object)"stateful")));
        technologyUsage.put("stats.services.ejb.messageDriven", this.countByType(EjbMessageDrivenModel.class));
        Map<ProjectModel, Integer> count = this.sum(this.countByType(EjbEntityBeanModel.class), this.countByType(JPAEntityModel.class));
        technologyUsage.put("stats.services.jpa.entities", count);
        technologyUsage.put("stats.services.jpa.namedQueries", this.countByType(JPANamedQueryModel.class));
        technologyUsage.put("stats.services.jpa.persistenceUnits", this.countByType(JPAPersistenceUnitModel.class));
        technologyUsage.put("stats.services.rmi.services", this.countByType(RMIServiceModel.class));
        technologyUsage.put("stats.services.hibernate.configurationFiles", this.countByType(HibernateConfigurationFileModel.class));
        technologyUsage.put("stats.services.hibernate.entities", this.countByType(HibernateEntityModel.class));
        technologyUsage.put("stats.services.hibernate.mappingFiles", this.countByType(HibernateMappingFileModel.class));
        technologyUsage.put("stats.services.hibernate.sessionFactories", this.countByType(HibernateSessionFactoryModel.class));
        technologyUsage.put("stats.serverResources.db.jdbcDatasources", this.countByType(DataSourceModel.class, (Map<String, Serializable>)new HashMap<String, Serializable>(){
            {
                this.put("isXA", false);
            }
        }));
        technologyUsage.put("stats.serverResources.db.xaJdbcDatasources", this.countByType(DataSourceModel.class, (Map<String, Serializable>)new HashMap<String, Serializable>(){
            {
                this.put("isXA", true);
            }
        }));
        technologyUsage.put("stats.services.http.jax-rs", this.countByType(JaxRSWebServiceModel.class));
        technologyUsage.put("stats.services.http.jax-ws", this.countByType(JaxWSWebServiceModel.class));
        technologyUsage.put("stats.serverResources.msg.jms.queues", this.countByType(JmsDestinationModel.class, "destinationType", (Serializable)((Object)JmsDestinationType.QUEUE.name())));
        technologyUsage.put("stats.serverResources.msg.jms.topics", this.countByType(JmsDestinationModel.class, "destinationType", (Serializable)((Object)JmsDestinationType.TOPIC.name())));
        technologyUsage.put("stats.serverResources.msg.jms.connectionFactories", this.countByType(JmsConnectionFactoryModel.class));
        technologyUsage.put("stats.serverResources.jndi.totalEntries", this.countByType(JNDIResourceModel.class));
        technologyUsage.put("stats.java.classes.original", this.countJavaClassesOriginal());
        technologyUsage.put("stats.java.classes.total", this.countByType(JavaClassModel.class));
        technologyUsage.put("stats.java.jars.original", this.diff(this.countByType(JarArchiveModel.class), this.countByType(IdentifiedArchiveModel.class)));
        technologyUsage.put("stats.java.jars.total", this.countByType(JarArchiveModel.class));
        return this.groupByProjectModel(technologyUsage);
    }

    protected Map<ProjectModel, Map<String, Integer>> groupByProjectModel(Map<String, Map<ProjectModel, Integer>> groupedByTechnology) {
        HashMap<ProjectModel, Map<String, Integer>> projectBasedResult = new HashMap<ProjectModel, Map<String, Integer>>();
        groupedByTechnology.entrySet().forEach(technologyMap -> ((Map)technologyMap.getValue()).entrySet().forEach(projectTechCount -> {
            ProjectModel project = (ProjectModel)projectTechCount.getKey();
            if (!projectBasedResult.containsKey(project)) {
                projectBasedResult.put(project, new HashMap());
            }
            ((Map)projectBasedResult.get(project)).put(technologyMap.getKey(), projectTechCount.getValue());
        }));
        return projectBasedResult;
    }

    protected Map<ProjectModel, Integer> sum(Map<ProjectModel, Integer> a, Map<ProjectModel, Integer> b) {
        HashMap<ProjectModel, Integer> result = new HashMap<ProjectModel, Integer>();
        a.entrySet().forEach(keyValuePair -> {
            Integer cfr_ignored_0 = (Integer)result.put((ProjectModel)keyValuePair.getKey(), (Integer)keyValuePair.getValue());
        });
        b.entrySet().forEach(keyValuePair -> result.put((ProjectModel)keyValuePair.getKey(), result.getOrDefault(keyValuePair.getKey(), 0) + (Integer)keyValuePair.getValue()));
        return result;
    }

    protected Map<ProjectModel, Integer> diff(Map<ProjectModel, Integer> a, Map<ProjectModel, Integer> b) {
        HashMap<ProjectModel, Integer> result = new HashMap<ProjectModel, Integer>();
        a.entrySet().forEach(keyValuePair -> {
            Integer cfr_ignored_0 = (Integer)result.put((ProjectModel)keyValuePair.getKey(), (Integer)keyValuePair.getValue());
        });
        b.entrySet().forEach(keyValuePair -> result.put((ProjectModel)keyValuePair.getKey(), (Integer)result.getOrDefault(keyValuePair.getKey(), (Integer)keyValuePair.getValue()) - (Integer)keyValuePair.getValue()));
        return result;
    }

    private <T extends WindupVertexFrame> Map<ProjectModel, Integer> countByType(Class<T> clazz) {
        return this.countByType(clazz, null);
    }

    private <T extends WindupVertexFrame> Map<ProjectModel, Integer> countByType(Class<T> clazz, final String propName, final Serializable value) {
        return this.countByType(clazz, (Map<String, Serializable>)(propName == null ? null : new HashMap<String, Serializable>(){
            {
                this.put(propName, value);
            }
        }));
    }

    private <T extends WindupVertexFrame> Map<ProjectModel, Integer> countByType(Class<T> clazz, Map<String, Serializable> props) {
        FramedGraphQuery query = this.getGraphContext().getQuery().type(clazz);
        if (props != null) {
            for (Map.Entry<String, Serializable> prop : props.entrySet()) {
                String propName = prop.getKey();
                Serializable value = prop.getValue();
                if (value == null) {
                    query = query.has(propName);
                    continue;
                }
                query = query.has(propName, (Object)value);
            }
        }
        HashMap<ProjectModel, Integer> projectCount = new HashMap<ProjectModel, Integer>();
        Iterable vertices = query.vertices(clazz);
        for (WindupVertexFrame vertex : vertices) {
            if (vertex instanceof BelongsToProject) {
                for (ProjectModel projectModel : ((BelongsToProject)vertex).getRootProjectModels()) {
                    projectCount.put(projectModel, projectCount.getOrDefault(projectModel, 0) + 1);
                }
                continue;
            }
            String errorMessage = "Not instance of " + BelongsToProject.class.getName() + "\n" + clazz.getName();
            LOG.warning(errorMessage);
        }
        LOG.info("Counted: Frame class == " + clazz.getSimpleName() + " && " + (props == null ? "no" : Integer.valueOf(props.size())));
        return projectCount;
    }

    public Map<ProjectModel, Map<String, Integer>> countFilesBySuffix() {
        HashMap<ProjectModel, Map<String, Integer>> result = new HashMap<ProjectModel, Map<String, Integer>>();
        Iterable files = this.getGraphContext().getQuery().type(FileModel.class).hasNot("isDirectory", (Object)true).vertices(FileModel.class);
        StreamSupport.stream(files.spliterator(), false).forEach(file -> {
            Map suffixToCount;
            Integer val;
            String suffix = StringUtils.substringAfterLast((String)file.getFileName(), (String)".");
            if (suffix.isEmpty() || file.isWindupGenerated().booleanValue()) {
                return;
            }
            ProjectModel projectModel = file.getProjectModel();
            if (projectModel == null) {
                return;
            }
            ProjectModel rootProjectModel = projectModel.getRootProjectModel();
            if (rootProjectModel == null) {
                throw new RuntimeException("RootProjectModel null");
            }
            if (!result.containsKey(rootProjectModel)) {
                result.put(rootProjectModel, new HashMap());
            }
            if ((val = (Integer)(suffixToCount = (Map)result.get(rootProjectModel)).get(suffix)) == null) {
                suffixToCount.put(suffix, 1);
            } else {
                suffixToCount.put(suffix, val + 1);
            }
        });
        return result;
    }

    private GeneralStatsItemModel item(int i) {
        return ((GeneralStatsItemModel)this.getGraphContext().create(GeneralStatsItemModel.class)).setQuantity(i);
    }

    private GeneralStatsItemModel item(String key, String label, Class<? extends WindupVertexFrame> type, Map<String, String> props) {
        GeneralStatsItemModel item = ((GeneralStatsItemModel)this.getGraphContext().create(GeneralStatsItemModel.class)).setKey(key).setLabel(label);
        long qty = this.countGraphVertices(type, props);
        item.setQuantity((int)qty);
        return item;
    }

    private long countGraphVertices(Class<? extends WindupVertexFrame> clazz, Map<String, String> props) {
        if (clazz == null) {
            throw new IllegalArgumentException("Frame type must be set (was null).");
        }
        LOG.info("Counting: Frame class == " + clazz.getSimpleName() + " && " + CollectionUtils.size(props) + " props.");
        FramedGraphQuery query = this.getGraphContext().getQuery().type(clazz);
        if (props != null) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                String key = e.getKey();
                if (key == null || key.isEmpty()) continue;
                if (e.getValue() == null) {
                    query = query.has(key);
                    continue;
                }
                query = query.has(key, (Object)e.getValue());
            }
        }
        long count = this.count(query.vertices());
        LOG.info(" ==> " + count);
        return count;
    }

    private Map<ProjectModel, Integer> countJavaClassesOriginal() {
        Iterable startVertices = new TypeAwareFramedGraphQuery(this.getGraphContext().getFramed()).type(JavaClassModel.class).vertices();
        Pipeline pipeline = new Pipeline();
        pipeline.addPipe((Pipe)new StartPipe((Object)startVertices));
        OutPipe outPipe = new OutPipe(new String[]{"decompiledSource"});
        pipeline.addPipe((Pipe)new BackFilterPipe((Pipe)outPipe));
        HashMap<ProjectModel, Integer> map = new HashMap<ProjectModel, Integer>();
        Iterable javaClassModels = this.getGraphContext().getFramed().frameVertices((Iterable)pipeline, JavaClassModel.class);
        javaClassModels.forEach(item -> {
            JavaSourceFileModel fileModel = item.getDecompiledSource();
            if (fileModel == null) {
                LOG.warning("Unexpected fileModel null");
                return;
            }
            ProjectModel projectModel = fileModel.getProjectModel();
            if (projectModel == null) {
                LOG.warning("Unexpected projectModel null");
                return;
            }
            ProjectModel rootProjectModel = projectModel.getRootProjectModel();
            map.put(rootProjectModel, map.getOrDefault(rootProjectModel, 0) + 1);
        });
        return map;
    }
}

