/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.service.JPAConfigurationFileService;
import org.jboss.windup.rules.apps.javaee.service.JPAEntityService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class, id="Create JPA Report")
public class CreateJPAReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_JPA_REPORT = "/reports/templates/jpa.ftl";
    public static final String REPORT_DESCRIPTION = "This report contains details JPA related resources that were found in the application.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        GraphOperation addReport = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : windupConfiguration.getInputPaths()) {
                    ProjectModel application = inputPath.getProjectModel();
                    if (application == null) {
                        throw new WindupException("Error, no project found in: " + inputPath.getFilePath());
                    }
                    CreateJPAReportRuleProvider.this.createJPAReport(event.getGraphContext(), application);
                }
            }

            public String toString() {
                return "CreateJPAReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)addReport);
    }

    private void createJPAReport(GraphContext context, ProjectModel application) {
        JPAConfigurationFileService jpaConfigurationFileService = new JPAConfigurationFileService(context);
        JPAEntityService jpaEntityService = new JPAEntityService(context);
        GraphService jpaNamedQueryService = new GraphService(context, JPANamedQueryModel.class);
        ArrayList<Object> jpaConfigList = new ArrayList<Object>();
        for (Object jpaConfig : jpaConfigurationFileService.findAll()) {
            Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)context, (ProjectModel)jpaConfig.getProjectModel());
            if (!applications.contains(application)) continue;
            jpaConfigList.add(jpaConfig);
        }
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (Object entityModel : jpaEntityService.findAll()) {
            if (!Iterables.contains(entityModel.getApplications(), (Object)application)) continue;
            entityList.add(entityModel);
        }
        ArrayList<JPANamedQueryModel> namedQueryList = new ArrayList<JPANamedQueryModel>();
        for (JPANamedQueryModel namedQuery : jpaNamedQueryService.findAll()) {
            if (!Iterables.contains(namedQuery.getJpaEntity().getApplications(), (Object)application)) continue;
            namedQueryList.add(namedQuery);
        }
        if (jpaConfigList.isEmpty() && entityList.isEmpty() && namedQueryList.isEmpty()) {
            return;
        }
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(3);
        additionalData.put("jpaConfiguration", ((WindupVertexListModel)listService.create()).addAll(jpaConfigList));
        additionalData.put("jpaEntities", ((WindupVertexListModel)listService.create()).addAll(entityList));
        additionalData.put("jpaNamedQueries", ((WindupVertexListModel)listService.create()).addAll(namedQueryList));
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(400);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("JPA");
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon jpa-nav-logo");
        applicationReportModel.setProjectModel(application);
        applicationReportModel.setTemplatePath(TEMPLATE_JPA_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        applicationReportModel.setRelatedResource(additionalData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "jpa_" + application.getName(), "html");
    }
}

