/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Not<E extends TitanElement>
implements Condition<E> {
    private final Condition<E> condition;

    public Not(Condition<E> condition) {
        Preconditions.checkNotNull(condition);
        this.condition = condition;
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.NOT;
    }

    public Condition<E> getChild() {
        return this.condition;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int numChildren() {
        return 1;
    }

    @Override
    public boolean evaluate(E element) {
        return !this.condition.evaluate(element);
    }

    @Override
    public Iterable<Condition<E>> getChildren() {
        return ImmutableList.of(this.condition);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append(this.condition).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other) && this.condition.equals(((Not)other).condition);
    }

    @Override
    public String toString() {
        return "!(" + this.condition.toString() + ")";
    }

    public static <E extends TitanElement> Not<E> of(Condition<E> element) {
        return new Not<E>(element);
    }
}

