/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.encoding;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import java.util.concurrent.TimeUnit;

public class ConversionHelper {
    public static final int getTTLSeconds(Duration duration) {
        Preconditions.checkArgument((duration != null && !duration.isZeroLength() ? 1 : 0) != 0, (Object)"Must provide non-zero TTL");
        long ttlSeconds = Math.max(1L, duration.getLength(TimeUnit.SECONDS));
        assert (ttlSeconds > 0L);
        Preconditions.checkArgument((ttlSeconds <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"tll value is too large [%s] - value overflow", (Object[])new Object[]{duration});
        return (int)ttlSeconds;
    }

    public static final int getTTLSeconds(long time, TimeUnit unit) {
        return ConversionHelper.getTTLSeconds(new StandardDuration(time, unit));
    }
}

