/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.config.Quickfix;
import org.jboss.windup.reporting.config.classification.ClassificationAs;
import org.jboss.windup.reporting.config.classification.ClassificationBuilderOf;
import org.jboss.windup.reporting.config.classification.ClassificationDescription;
import org.jboss.windup.reporting.config.classification.ClassificationEffort;
import org.jboss.windup.reporting.config.classification.ClassificationLink;
import org.jboss.windup.reporting.config.classification.ClassificationQuickfix;
import org.jboss.windup.reporting.config.classification.ClassificationTags;
import org.jboss.windup.reporting.config.classification.ClassificationWithIssueCategory;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.QuickfixModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.QuickfixService;
import org.jboss.windup.reporting.service.TagSetService;
import org.jboss.windup.rules.files.model.FileReferenceModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Classification
extends ParameterizedIterationOperation<FileModel>
implements ClassificationAs,
ClassificationEffort,
ClassificationDescription,
ClassificationLink,
ClassificationTags,
ClassificationWithIssueCategory,
ClassificationQuickfix {
    private static final Logger LOG = Logging.get(Classification.class);
    private List<Link> links = new ArrayList<Link>();
    private Set<String> tags = new HashSet<String>();
    private List<Quickfix> quickfixes = new ArrayList<Quickfix>();
    private RegexParameterizedPatternParser classificationPattern;
    private RegexParameterizedPatternParser descriptionPattern;
    private int effort;
    private IssueCategory issueCategory = null;

    Classification(String variable) {
        super(variable);
    }

    Classification() {
    }

    public static ClassificationBuilderOf of(String variable) {
        return new ClassificationBuilderOf(variable);
    }

    public static ClassificationAs as(String classification) {
        Assert.notNull((Object)classification, (String)"Classification text must not be null.");
        Classification result = new Classification();
        result.classificationPattern = new RegexParameterizedPatternParser(classification);
        return result;
    }

    public List<Quickfix> getQuickfixes() {
        return this.quickfixes;
    }

    public FileModel resolvePayload(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        this.checkVariableName(event, context);
        if (payload instanceof FileReferenceModel) {
            return ((FileReferenceModel)payload).getFile();
        }
        if (payload instanceof FileModel) {
            return (FileModel)payload;
        }
        return null;
    }

    public IssueCategory getIssueCategory() {
        return this.issueCategory;
    }

    @Override
    public ClassificationWithIssueCategory withIssueCategory(IssueCategory issueCategory) {
        this.issueCategory = issueCategory;
        return this;
    }

    @Override
    public ClassificationDescription withDescription(String description) {
        this.descriptionPattern = new RegexParameterizedPatternParser(description);
        return this;
    }

    @Override
    public ClassificationLink with(Link link) {
        this.links.add(link);
        return this;
    }

    @Override
    public ClassificationQuickfix withQuickfix(Quickfix fix) {
        this.quickfixes.add(fix);
        return this;
    }

    @Override
    public ClassificationTags withTags(Set<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    @Override
    public Classification withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    private Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performParameterized(GraphRewrite event, EvaluationContext context, FileModel payload) {
        ExecutionStatistics.get().begin("Classification.performParameterized");
        try {
            String text;
            String description = null;
            if (this.descriptionPattern != null) {
                try {
                    description = this.descriptionPattern.getBuilder().build((Rewrite)event, context);
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Failed to generate parameterized Classification description due to: " + t.getMessage(), t);
                    description = this.descriptionPattern.toString();
                }
            }
            try {
                text = this.classificationPattern.getBuilder().build((Rewrite)event, context);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failed to generate parameterized Classification due to: " + t.getMessage(), t);
                text = this.classificationPattern.toString();
            }
            GraphContext graphContext = event.getGraphContext();
            ClassificationService classificationService = new ClassificationService(graphContext);
            ClassificationModel classification = (ClassificationModel)classificationService.getUniqueByProperty("ClassificationModel:classification", text);
            if (classification == null) {
                classification = (ClassificationModel)classificationService.create();
                classification.setEffort(this.effort);
                IssueCategoryModel issueCategoryModel = this.issueCategory == null ? IssueCategoryRegistry.loadFromGraph(event.getGraphContext(), "optional") : IssueCategoryRegistry.loadFromGraph(event.getGraphContext(), this.issueCategory.getCategoryID());
                classification.setIssueCategory(issueCategoryModel);
                classification.setDescription(StringUtils.trim((String)description));
                classification.setClassification(StringUtils.trim((String)text));
                HashSet<String> tags = new HashSet<String>(this.getTags());
                TagSetService tagSetService = new TagSetService(event.getGraphContext());
                classification.setTagModel(tagSetService.getOrCreate(event, tags));
                classification.setRuleID(((Rule)context.get(Rule.class)).getId());
                LinkService linkService = new LinkService(graphContext);
                for (Link link : this.links) {
                    LinkModel linkModel = linkService.getOrCreate(StringUtils.trim((String)link.getTitle()), StringUtils.trim((String)link.getLink()));
                    classification.addLink(linkModel);
                }
                QuickfixService quickfixService = new QuickfixService(graphContext);
                for (Quickfix quickfix : this.quickfixes) {
                    QuickfixModel quickfixModel = (QuickfixModel)quickfixService.create();
                    quickfixModel.setQuickfixType(quickfix.getType());
                    quickfixModel.setName(StringUtils.trim((String)quickfix.getName()));
                    quickfixModel.setReplacement(StringUtils.trim((String)quickfix.getReplacementStr()));
                    quickfixModel.setSearch(StringUtils.trim((String)quickfix.getSearchStr()));
                    quickfixModel.setNewline(StringUtils.trim((String)quickfix.getNewline()));
                    classification.addQuickfix(quickfixModel);
                }
            }
            classificationService.attachClassification(event, classification, payload);
            if (payload instanceof SourceFileModel) {
                ((SourceFileModel)payload).setGenerateSourceReport(true);
            }
            LOG.info("Classification added to " + payload.getPrettyPathWithinProject() + " [" + this + "] ");
        }
        finally {
            ExecutionStatistics.get().end("Classification.performParameterized");
        }
    }

    protected void setClassificationText(String classification) {
        this.classificationPattern = new RegexParameterizedPatternParser(classification);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Classification.as(").append(this.classificationPattern.getPattern()).append(")");
        if (this.descriptionPattern != null && !this.descriptionPattern.getPattern().trim().isEmpty()) {
            result.append(".withDescription(").append(this.descriptionPattern).append(")");
        }
        if (this.effort != 0) {
            result.append(".withEffort(").append(this.effort).append(")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(").append(this.links).append(")");
        }
        return result.toString();
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public RegexParameterizedPatternParser getClassificationPattern() {
        return this.classificationPattern;
    }

    public RegexParameterizedPatternParser getDescriptionPattern() {
        return this.descriptionPattern;
    }

    public int getEffort() {
        return this.effort;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>(this.classificationPattern.getRequiredParameterNames());
        if (this.descriptionPattern != null) {
            result.addAll(this.descriptionPattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.classificationPattern.setParameterStore(store);
        if (this.descriptionPattern != null) {
            this.descriptionPattern.setParameterStore(store);
        }
    }
}

