/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.util.Logging;

public class ApplicationReportService
extends GraphService<ApplicationReportModel> {
    private static final Logger LOG = Logging.get(ApplicationReportService.class);

    public ApplicationReportService(GraphContext context) {
        super(context, ApplicationReportModel.class);
    }

    public ApplicationReportModel create() {
        ApplicationReportModel applicationReportModel = (ApplicationReportModel)super.create();
        applicationReportModel.setDisplayInApplicationReportIndex(false);
        applicationReportModel.setMainApplicationReport(false);
        applicationReportModel.setReportPriority(Integer.MAX_VALUE);
        return applicationReportModel;
    }

    public ApplicationReportModel getMainApplicationReportForFile(FileModel fileModel) {
        GremlinPipeline pipe = new GremlinPipeline((Object)this.getGraphContext().getGraph());
        pipe.V("w:winduptype", (Object)"ApplicationReport");
        pipe.has("mainApplicationModel", (Object)true);
        pipe.as("applicationReport");
        pipe.out(new String[]{"reportToProjectModel"});
        ProjectModel rootProjectModel = fileModel.getProjectModel();
        if (rootProjectModel == null) {
            return null;
        }
        rootProjectModel = rootProjectModel.getRootProjectModel();
        String rootFilePath = rootProjectModel.getRootFileModel().getFilePath();
        pipe.out(new String[]{"rootFileModel"});
        pipe.has("filePath", (Object)rootFilePath);
        pipe.back("applicationReport");
        if (pipe.iterator().hasNext()) {
            Vertex v = (Vertex)pipe.iterator().next();
            ApplicationReportModel mainAppReport = (ApplicationReportModel)this.frame(v);
            if (pipe.iterator().hasNext()) {
                LOG.warning("There are multiple ApplicationReportModels for a single file " + fileModel.getFilePath() + ". This may cause some brokenlinks in the report file");
            }
            return mainAppReport;
        }
        return null;
    }
}

