/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.service.ClassificationServiceCache;
import org.jboss.windup.reporting.service.EffortAccumulatorFunction;
import org.jboss.windup.reporting.service.MapSumEffortAccumulatorFunction;
import org.jboss.windup.reporting.service.SetMembersFilter;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ClassificationService
extends GraphService<ClassificationModel> {
    public static final Logger LOG = Logger.getLogger(ClassificationService.class.getName());

    public ClassificationService(GraphContext context) {
        super(context, ClassificationModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        classificationPipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        classificationPipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
        classificationPipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        int classificationEffort = 0;
        for (Vertex v : classificationPipeline) {
            Integer migrationEffort = (Integer)v.getProperty("EffortReportModelEffort");
            if (migrationEffort == null) continue;
            classificationEffort += migrationEffort.intValue();
        }
        return classificationEffort;
    }

    public Iterable<ClassificationModel> getClassifications(FileModel model) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)model.asVertex());
        pipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        pipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, ClassificationModel.class);
    }

    public Iterable<ClassificationModel> getClassificationByName(FileModel model, String classificationName) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)model.asVertex());
        pipeline.in(new String[]{"ClassificationModel:classificationModelToFileModel"});
        pipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        pipeline.has("ClassificationModel:classification", (Object)classificationName);
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)pipeline, ClassificationModel.class);
    }

    public Map<Integer, Integer> getMigrationEffortByPoints(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive, boolean includeZero) {
        MapSumEffortAccumulatorFunction accumulator = new MapSumEffortAccumulatorFunction(){

            public Integer vertexToKey(Vertex effortReportVertex) {
                Integer migrationEffort = (Integer)effortReportVertex.getProperty("EffortReportModelEffort");
                return migrationEffort;
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, recursive, includeZero, accumulator);
        return accumulator.getResults();
    }

    public Map<IssueCategoryModel, Integer> getMigrationEffortBySeverity(GraphRewrite event, ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive) {
        MapSumEffortAccumulatorFunction<IssueCategoryModel> accumulator = new MapSumEffortAccumulatorFunction<IssueCategoryModel>(){

            @Override
            public IssueCategoryModel vertexToKey(Vertex effortReportVertex) {
                return ((ClassificationModel)ClassificationService.this.frame(effortReportVertex)).getIssueCategory();
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, recursive, true, accumulator);
        return accumulator.getResults();
    }

    private void getMigrationEffortDetails(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive, boolean includeZero, EffortAccumulatorFunction accumulatorFunction) {
        LOG.log(Level.INFO, String.format("\n\t\t\tEFFORT C: getMigrationEffortDetails() with: %s, %srecur, %sincludeZero, %s, tags: %s, excl: %s", traversal, recursive ? "" : "!", includeZero ? "" : "!", accumulatorFunction, includeTags, excludeTags));
        Set initialVertices = traversal.getAllProjectsAsVertices(recursive);
        GremlinPipeline pipeline = new GremlinPipeline((Object)this.getGraphContext().getGraph());
        pipeline.V();
        if (!includeZero) {
            pipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
            pipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"ClassificationModel");
        } else {
            pipeline.has("w:winduptype", (Object)"ClassificationModel");
        }
        pipeline.as("classification");
        pipeline.out(new String[]{"ClassificationModel:classificationModelToFileModel"});
        pipeline.in(new String[]{"projectModelToFile"});
        pipeline.filter((PipeFunction)new SetMembersFilter(initialVertices));
        pipeline.back("classification");
        boolean checkTags = !includeTags.isEmpty() || !excludeTags.isEmpty();
        FileService fileService = new FileService(this.getGraphContext());
        for (Vertex v : pipeline) {
            if (checkTags && !((ClassificationModel)this.frame(v)).matchesTags(includeTags, excludeTags)) continue;
            for (Vertex fileVertex : v.getVertices(Direction.OUT, new String[]{"ClassificationModel:classificationModelToFileModel"})) {
                FileModel fileModel = (FileModel)fileService.frame(fileVertex);
                if (!initialVertices.contains(fileModel.getProjectModel().asVertex())) continue;
                accumulatorFunction.accumulate(v);
            }
        }
    }

    public ClassificationModel attachClassification(GraphRewrite event, Rule rule, FileModel fileModel, String classificationText, String description) {
        ClassificationModel model = (ClassificationModel)this.getUnique(this.getTypedQuery().has("ClassificationModel:classification", (Object)classificationText));
        if (model == null) {
            model = (ClassificationModel)this.create();
            model.setClassification(classificationText);
            model.setDescription(description);
            model.setEffort(0);
            model.setRuleID(rule.getId());
            model.addFileModel(fileModel);
            if (fileModel instanceof SourceFileModel) {
                ((SourceFileModel)fileModel).setGenerateSourceReport(true);
            }
            ClassificationServiceCache.cacheClassificationFileModel(event, model, fileModel, true);
            return model;
        }
        return this.attachClassification(event, model, fileModel);
    }

    public ClassificationModel attachClassification(GraphRewrite event, EvaluationContext context, FileModel fileModel, String classificationText, String description) {
        Rule rule = (Rule)context.get(Rule.class);
        return this.attachClassification(event, rule, fileModel, classificationText, description);
    }

    private boolean isClassificationLinkedToFileModel(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel) {
        return ClassificationServiceCache.isClassificationLinkedToFileModel(event, classificationModel, fileModel);
    }

    public ClassificationModel attachClassification(GraphRewrite event, ClassificationModel classificationModel, FileModel fileModel) {
        if (!this.isClassificationLinkedToFileModel(event, classificationModel, fileModel)) {
            classificationModel.addFileModel(fileModel);
            if (fileModel instanceof SourceFileModel) {
                ((SourceFileModel)fileModel).setGenerateSourceReport(true);
            }
        }
        ClassificationServiceCache.cacheClassificationFileModel(event, classificationModel, fileModel, true);
        return classificationModel;
    }

    public ClassificationModel attachLink(ClassificationModel classificationModel, LinkModel linkModel) {
        for (LinkModel existing : classificationModel.getLinks()) {
            if (!StringUtils.equals((CharSequence)existing.getLink(), (CharSequence)linkModel.getLink())) continue;
            return classificationModel;
        }
        classificationModel.addLink(linkModel);
        return classificationModel;
    }
}

