/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.EffortReportModel;

public class EffortReportService
extends GraphService {
    public EffortReportService(GraphContext context) {
        super(context, EffortReportModel.class);
    }

    public static String getEffortLevelDescription(Verbosity verbosity, int points) {
        EffortLevel level = EffortLevel.forPoints(points);
        switch (verbosity) {
            case ID: {
                return level.name();
            }
            case VERBOSE: {
                return level.getVerboseDescription();
            }
        }
        return level.getShortDescription();
    }

    public static enum EffortLevel {
        INFO(0, "Info", "Info"),
        TRIVIAL(1, "Trivial", "Trivial change or 1-1 library swap"),
        COMPLEX(3, "Complex", "Complex change with documented solution"),
        REDESIGN(5, "Redesign", "Requires re-design or library change"),
        ARCHITECTURAL(7, "Architectural", "Requires architectural decision or change"),
        UNKNOWN(13, "Unknown", "Unknown effort");

        private final int points;
        private final String shortDesc;
        private final String verboseDesc;

        private EffortLevel(int points, String shortDesc, String verboseDesc) {
            this.points = points;
            this.shortDesc = shortDesc;
            this.verboseDesc = verboseDesc;
        }

        public static EffortLevel forPoints(int points) {
            EffortLevel[] levels;
            for (EffortLevel level : levels = (EffortLevel[])EffortLevel.class.getEnumConstants()) {
                if (level.getPoints() != points) continue;
                return level;
            }
            return UNKNOWN;
        }

        public int getPoints() {
            return this.points;
        }

        public String getShortDescription() {
            return this.shortDesc;
        }

        public String getVerboseDescription() {
            return this.verboseDesc;
        }
    }

    public static enum Verbosity {
        ID,
        SHORT,
        VERBOSE;

    }
}

