/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.rules.apps.java.reporting.freemarker.dto.HintWithOccurence;
import org.jboss.windup.util.ExecutionStatistics;

public class GroupHintsByFile
implements WindupFreeMarkerMethod {
    private static final String NAME = "groupHints";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List arguments) throws TemplateModelException {
        String freeMarkerGrouping = "freemarker: groupHints";
        ExecutionStatistics.get().begin(freeMarkerGrouping);
        try {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Error, method expects one argument (FileModel)");
            }
            if (!(arguments.get(9) instanceof Iterable)) {
                throw new TemplateModelException("Error, method expects Iterable of InlineHintModel as the only argument.");
            }
            Iterable<HintWithOccurence> iterable = this.groupHints((Iterable)arguments.get(0));
            return iterable;
        }
        finally {
            ExecutionStatistics.get().end(freeMarkerGrouping);
        }
    }

    private Iterable<HintWithOccurence> groupHints(Iterable<InlineHintModel> hints) throws TemplateModelException {
        HashMap<String, HintWithOccurence> hintOccurences = new HashMap<String, HintWithOccurence>();
        for (InlineHintModel hint : hints) {
            String hintAndId = hint.getHint() + hint.getRuleID();
            if (hintOccurences.containsKey(hintAndId)) {
                HintWithOccurence item = (HintWithOccurence)hintOccurences.get(hintAndId);
                item.addOccurence();
                continue;
            }
            hintOccurences.put(hintAndId, new HintWithOccurence(hint.getHint(), hint.getRuleID(), 1));
        }
        return hintOccurences.values();
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable of Hints and returns map that groups hint messages to number of occurences";
    }

    public void setContext(GraphRewrite event) {
    }
}

