/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.sleepycat.je.LockMode;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphConfiguration;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.FrameClassLoaderResolver;
import com.tinkerpop.frames.modules.MethodHandler;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.gremlingroovy.GremlinGroovyModule;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Annotations;
import org.jboss.windup.graph.DefaultValueInitializer;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Indexes;
import org.jboss.windup.graph.MapInAdjacentPropertiesHandler;
import org.jboss.windup.graph.MapInAdjacentVerticesHandler;
import org.jboss.windup.graph.MapInPropertiesHandler;
import org.jboss.windup.graph.SetInPropertiesHandler;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.listeners.AfterGraphInitializationListener;
import org.jboss.windup.graph.listeners.BeforeGraphCloseListener;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;

public class GraphContextImpl
implements GraphContext {
    private static final Logger LOG = Logger.getLogger(GraphContextImpl.class.getName());
    private final Furnace furnace;
    private final GraphTypeManager graphTypeManager;
    private final Path graphDir;
    private final GraphApiCompositeClassLoaderProvider classLoaderProvider;
    private final Map<String, BeforeGraphCloseListener> beforeGraphCloseListenerBuffer = new HashMap<String, BeforeGraphCloseListener>();
    private Map<String, Object> configurationOptions;
    private EventGraph<TitanGraph> eventGraph;
    private BatchGraph<TitanGraph> batchGraph;
    private FramedGraph<EventGraph<TitanGraph>> framed;
    private Configuration conf;

    public GraphContextImpl(Furnace furnace, GraphTypeManager typeManager, GraphApiCompositeClassLoaderProvider classLoaderProvider, Path graphDir) {
        this.furnace = furnace;
        this.graphTypeManager = typeManager;
        this.classLoaderProvider = classLoaderProvider;
        this.graphDir = graphDir;
    }

    public GraphContextImpl create() {
        FileUtils.deleteQuietly((File)this.graphDir.toFile());
        TitanGraph titan = this.initializeTitanGraph();
        this.initializeTitanIndexes(titan);
        this.createFramed(titan);
        this.fireListeners();
        return this;
    }

    public GraphContextImpl load() {
        TitanGraph titan = this.initializeTitanGraph();
        this.createFramed(titan);
        this.fireListeners();
        return this;
    }

    private void fireListeners() {
        Imported afterInitializationListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(AfterGraphInitializationListener.class);
        HashMap<String, Object> confProps = new HashMap<String, Object>();
        Iterator keyIter = this.conf.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            confProps.put(key, this.conf.getProperty(key));
        }
        if (!afterInitializationListeners.isUnsatisfied()) {
            for (AfterGraphInitializationListener listener : afterInitializationListeners) {
                listener.afterGraphStarted(confProps, (GraphContext)this);
                if (!(listener instanceof BeforeGraphCloseListener)) continue;
                this.beforeGraphCloseListenerBuffer.put(listener.getClass().toString(), (BeforeGraphCloseListener)listener);
            }
        }
    }

    private void createFramed(TitanGraph titanGraph) {
        this.eventGraph = new EventGraph((Graph)titanGraph);
        this.batchGraph = new BatchGraph((TransactionalGraph)titanGraph, 1000L);
        final ClassLoader compositeClassLoader = this.classLoaderProvider.getCompositeClassLoader();
        final FrameClassLoaderResolver classLoaderResolver = new FrameClassLoaderResolver(){

            public ClassLoader resolveClassLoader(Class<?> frameType) {
                return compositeClassLoader;
            }
        };
        Module addModules = new Module(){

            public Graph configure(Graph baseGraph, FramedGraphConfiguration config) {
                config.setFrameClassLoaderResolver(classLoaderResolver);
                config.addFrameInitializer((FrameInitializer)new DefaultValueInitializer());
                config.addMethodHandler((MethodHandler)new MapInPropertiesHandler());
                config.addMethodHandler((MethodHandler)new MapInAdjacentPropertiesHandler());
                config.addMethodHandler((MethodHandler)new MapInAdjacentVerticesHandler());
                config.addMethodHandler((MethodHandler)new SetInPropertiesHandler());
                return baseGraph;
            }
        };
        FramedGraphFactory factory = new FramedGraphFactory(new Module[]{addModules, new JavaHandlerModule(), this.graphTypeManager.build(), new GremlinGroovyModule()});
        this.framed = factory.create(this.eventGraph);
    }

    private List<Indexed> getIndexAnnotations(Method method) {
        Indexes indexes;
        ArrayList<Indexed> results = new ArrayList<Indexed>();
        Indexed index = method.getAnnotation(Indexed.class);
        if (index != null) {
            results.add(index);
        }
        if ((indexes = method.getAnnotation(Indexes.class)) != null) {
            Collections.addAll(results, indexes.value());
        }
        return results;
    }

    private void initializeTitanIndexes(TitanGraph titanGraph) {
        PropertyKey propKey;
        Class dataType;
        HashMap<String, IndexData> defaultIndexKeys = new HashMap<String, IndexData>();
        HashMap<String, IndexData> searchIndexKeys = new HashMap<String, IndexData>();
        HashMap<String, IndexData> listIndexKeys = new HashMap<String, IndexData>();
        Set modelTypes = this.graphTypeManager.getRegisteredTypes();
        for (Iterator type : modelTypes) {
            for (Method method : ((Class)((Object)type)).getDeclaredMethods()) {
                List<Indexed> annotations = this.getIndexAnnotations(method);
                for (Indexed index : annotations) {
                    Property property = (Property)Annotations.getAnnotation((Method)method, Property.class);
                    if (property == null) continue;
                    Class dataType2 = index.dataType();
                    switch (index.value()) {
                        case DEFAULT: {
                            defaultIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                        case SEARCH: {
                            searchIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                        case LIST: {
                            listIndexKeys.put(property.value(), new IndexData(property.value(), index.name(), dataType2));
                            break;
                        }
                    }
                }
            }
        }
        listIndexKeys.put("w:winduptype", new IndexData("w:winduptype", "", String.class));
        LOG.info("Detected and initialized [" + defaultIndexKeys.size() + "] default indexes: " + defaultIndexKeys);
        LOG.info("Detected and initialized [" + searchIndexKeys.size() + "] search indexes: " + searchIndexKeys);
        LOG.info("Detected and initialized [" + listIndexKeys.size() + "] list indexes: " + listIndexKeys);
        TitanManagement titan = titanGraph.getManagementSystem();
        for (Map.Entry entry : defaultIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            propKey = this.getOrCreatePropertyKey(titan, key, dataType, Cardinality.SINGLE);
            titan.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        for (Map.Entry entry : searchIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            if (dataType == String.class) {
                propKey = this.getOrCreatePropertyKey(titan, key, String.class, Cardinality.SINGLE);
                titan.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey, new Parameter[]{Mapping.STRING.getParameter()}).buildMixedIndex("search");
                continue;
            }
            propKey = this.getOrCreatePropertyKey(titan, key, dataType, Cardinality.SINGLE);
            titan.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildMixedIndex("search");
        }
        for (Map.Entry entry : listIndexKeys.entrySet()) {
            String key = (String)entry.getKey();
            IndexData indexData = (IndexData)entry.getValue();
            dataType = indexData.type;
            propKey = this.getOrCreatePropertyKey(titan, key, dataType, Cardinality.LIST);
            titan.buildIndex(indexData.getIndexName(), Vertex.class).addKey(propKey).buildCompositeIndex();
        }
        String indexName = "edge-typevalue";
        PropertyKey propKey2 = this.getOrCreatePropertyKey(titan, "w:winduptype", String.class, Cardinality.LIST);
        titan.buildIndex(indexName, Edge.class).addKey(propKey2).buildCompositeIndex();
        titan.commit();
    }

    private PropertyKey getOrCreatePropertyKey(TitanManagement titanGraph, String key, Class<?> dataType, Cardinality cardinality) {
        PropertyKey propertyKey = titanGraph.getPropertyKey(key);
        if (propertyKey == null) {
            propertyKey = titanGraph.makePropertyKey(key).dataType(dataType).cardinality(cardinality).make();
        }
        return propertyKey;
    }

    private TitanGraph initializeTitanGraph() {
        LOG.fine("Initializing graph.");
        Path lucene = this.graphDir.resolve("graphsearch");
        Path berkeley = this.graphDir.resolve("titangraph");
        this.conf = new BaseConfiguration();
        this.conf.setProperty("graph.unique-instance-id", (Object)("windup_" + System.nanoTime() + "_" + RandomStringUtils.randomAlphabetic((int)6)));
        this.conf.setProperty("storage.directory", (Object)berkeley.toAbsolutePath().toString());
        this.conf.setProperty("storage.backend", (Object)"berkeleyje");
        this.conf.setProperty("storage.berkeleydb.cache-percentage", (Object)1);
        this.conf.setProperty("storage.berkeleydb.lock-mode", (Object)LockMode.READ_UNCOMMITTED);
        this.conf.setProperty("storage.berkeleydb.isolation-level", (Object)BerkeleyJEStoreManager.IsolationLevel.READ_UNCOMMITTED);
        this.conf.setProperty("storage.buffer-size", (Object)"4096");
        this.conf.setProperty("storage.transactions", (Object)false);
        this.conf.setProperty("ids.block-size", (Object)25000);
        this.conf.setProperty("cache.db-cache", (Object)true);
        this.conf.setProperty("cache.db-cache-clean-wait", (Object)0);
        this.conf.setProperty("cache.db-cache-size", (Object)0.09);
        this.conf.setProperty("cache.db-cache-time", (Object)0);
        this.conf.setProperty("index.search.backend", (Object)"lucene");
        this.conf.setProperty("index.search.directory", (Object)lucene.toAbsolutePath().toString());
        this.writeToPropertiesFile(this.conf, this.graphDir.resolve("TitanConfiguration.properties").toFile());
        return TitanFactory.open((Configuration)this.conf);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public GraphTypeManager getGraphTypeManager() {
        return this.graphTypeManager;
    }

    public void close() {
        try {
            Imported beforeCloseListeners = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(BeforeGraphCloseListener.class);
            for (BeforeGraphCloseListener listener : beforeCloseListeners) {
                if (this.beforeGraphCloseListenerBuffer.containsKey(listener.getClass().toString())) continue;
                this.beforeGraphCloseListenerBuffer.put(listener.getClass().toString(), listener);
            }
            for (BeforeGraphCloseListener listener : this.beforeGraphCloseListenerBuffer.values()) {
                listener.beforeGraphClose();
            }
            this.beforeGraphCloseListenerBuffer.clear();
        }
        catch (Exception e) {
            LOG.warning("Could not call before shutdown listeners during close due to: " + e.getMessage());
        }
        ((TitanGraph)this.eventGraph.getBaseGraph()).shutdown();
    }

    public void clear() {
        if (this.eventGraph == null) {
            return;
        }
        if (this.eventGraph.getBaseGraph() == null) {
            return;
        }
        if (((TitanGraph)this.eventGraph.getBaseGraph()).isOpen()) {
            this.close();
        }
        TitanCleanup.clear((TitanGraph)((TitanGraph)this.eventGraph.getBaseGraph()));
    }

    public EventGraph<TitanGraph> getGraph() {
        return this.eventGraph;
    }

    public BatchGraph<TitanGraph> getBatch() {
        return this.batchGraph;
    }

    public FramedGraph<EventGraph<TitanGraph>> getFramed() {
        return this.framed;
    }

    public TypeAwareFramedGraphQuery getQuery() {
        return new TypeAwareFramedGraphQuery(this.getFramed());
    }

    public Path getGraphDirectory() {
        return this.graphDir;
    }

    public Map<String, Object> getOptionMap() {
        if (this.configurationOptions == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public void setOptions(Map<String, Object> options) {
        this.configurationOptions = options;
    }

    public String toString() {
        String graphHash = this.getGraph() == null ? "null" : "" + this.getGraph().hashCode();
        return "GraphContextImpl(" + this.hashCode() + "), Graph(" + graphHash + ") + DataDir(" + this.getGraphDirectory() + ")";
    }

    private void writeToPropertiesFile(Configuration conf, File file) {
        try {
            PropertiesConfiguration propConf = new PropertiesConfiguration(file);
            propConf.append(conf);
            propConf.save();
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("Failed writing Titan config to " + file.getAbsolutePath() + ": " + ex.getMessage(), ex);
        }
    }

    public <T extends WindupVertexFrame> GraphService<T> service(Class<T> clazz) {
        return new GraphService((GraphContext)this, clazz);
    }

    public <T extends WindupVertexFrame> T getUnique(Class<T> clazz) {
        return (T)this.service(clazz).getUnique();
    }

    public <T extends WindupVertexFrame> Iterable<T> findAll(Class<T> clazz) {
        return this.service(clazz).findAll();
    }

    public <T extends WindupVertexFrame> T create(Class<T> clazz) {
        return (T)this.service(clazz).create();
    }

    public void commit() {
        ((TitanGraph)this.getGraph().getBaseGraph()).commit();
    }

    private class IndexData {
        private final String propertyName;
        private final String indexName;
        private final Class<?> type;

        public IndexData(String propertyName, String indexName, Class<?> type) {
            this.propertyName = propertyName;
            this.indexName = indexName;
            this.type = type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getIndexName() {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.indexName, (CharSequence)this.propertyName);
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return String.format("IndexData{propertyName='%s', indexName='%s', type=%s}", this.propertyName, this.indexName, this.type);
        }
    }
}

