/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.logging.impl.UnsupportedSlf4jBindingConfiguration;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.maven.projects.MavenBuildManager;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.util.NativeSystemCall;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class MavenFacetImpl
extends AbstractFacet<Project>
implements ProjectFacet,
MavenFacet {
    private static final Logger log = Logger.getLogger(MavenFacetImpl.class.getName());
    private static final MavenBuildManager BUILD_MANAGER = new MavenBuildManager();

    public boolean install() {
        if (!this.isInstalled()) {
            MavenModelResource pom = this.getModelResource();
            if (!pom.createNewFile()) {
                throw new IllegalStateException("Could not create POM file.");
            }
            pom.setContents(this.createDefaultPOM());
        }
        return this.isInstalled();
    }

    private String createDefaultPOM() {
        MavenXpp3Writer writer = new MavenXpp3Writer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MavenProject mavenProject = new MavenProject();
        mavenProject.setModelVersion("4.0.0");
        try {
            writer.write((OutputStream)baos, mavenProject.getModel());
            return baos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default pom.xml", e);
        }
    }

    public MavenModelResource getModelResource() {
        return (MavenModelResource)((Project)this.getFaceted()).getRoot().getChild("pom.xml").reify(MavenModelResource.class);
    }

    public boolean isInstalled() {
        MavenModelResource pom = this.getModelResource();
        return pom != null && pom.exists();
    }

    public Model getModel() {
        return this.getModelResource().getCurrentModel();
    }

    public void setModel(Model pom) {
        MavenModelResource modelResource = this.getModelResource();
        try {
            modelResource.setCurrentModel(pom);
        }
        finally {
            BUILD_MANAGER.evictFromCache(modelResource);
        }
    }

    public synchronized ProjectBuildingResult getProjectBuildingResult() throws ProjectBuildingException {
        return BUILD_MANAGER.getProjectBuildingResult(this.getModelResource());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Properties properties = this.getProjectBuildingResult().getProject().getProperties();
            for (Map.Entry<Object, Object> o : properties.entrySet()) {
                result.put((String)o.getKey(), (String)o.getValue());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to resolve properties in [" + this.getModelResource().getFullyQualifiedName() + "].");
            log.log(Level.FINE, "Failed to resolve properties in Project [" + this.getModelResource().getFullyQualifiedName() + "].", e);
        }
        return result;
    }

    public String resolveProperties(String input) {
        String result = input;
        try {
            if (input != null) {
                Properties properties = this.getProjectBuildingResult().getProject().getProperties();
                for (Map.Entry<Object, Object> e : properties.entrySet()) {
                    String key = "\\$\\{" + e.getKey().toString() + "\\}";
                    Object value = e.getValue();
                    result = result.replaceAll(key, value.toString());
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to resolve properties in [" + this.getModelResource().getFullyQualifiedName() + "] for input value [" + input + "].");
            log.log(Level.FINE, "Failed to resolve properties in Project [" + this.getModelResource().getFullyQualifiedName() + "].", e);
        }
        return result;
    }

    public boolean executeMavenEmbedded(List<String> parameters) {
        return this.executeMavenEmbedded(parameters.toArray(new String[parameters.size()]));
    }

    public boolean executeMavenEmbedded(String[] parms) {
        return this.executeMavenEmbedded(System.out, System.err, parms);
    }

    public boolean executeMavenEmbedded(List<String> parameters, PrintStream out, PrintStream err) {
        return this.executeMavenEmbedded(out, err, parameters.toArray(new String[parameters.size()]));
    }

    public boolean executeMavenEmbedded(PrintStream out, PrintStream err, String[] arguments) {
        ArrayList<String> list = new ArrayList<String>();
        if (System.getProperty("org.apache.maven.user-settings") != null) {
            list.add("-s");
            list.add(System.getProperty("org.apache.maven.user-settings"));
        } else if (System.getProperty("org.apache.maven.global-settings") != null) {
            list.add("-s");
            list.add(System.getProperty("org.apache.maven.global-settings"));
        }
        if (arguments != null) {
            list.addAll(Arrays.asList(arguments));
        }
        return this.doExecuteMavenEmbedded(out, err, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecuteMavenEmbedded(PrintStream out, PrintStream err, List<String> list) {
        boolean quiet = list.contains("-q") || list.contains("--quiet");
        String[] params = list.toArray(new String[list.size()]);
        Logger globalLogger = Logger.getLogger("");
        UncloseableStreamHandler outHandler = new UncloseableStreamHandler(out, quiet);
        try {
            boolean bl;
            globalLogger.addHandler(outHandler);
            PrintStream oldout = System.out;
            PrintStream olderr = System.err;
            try {
                System.setOut(out);
                System.setErr(err);
                CliRequest cliRequest = this.createCliRequest(params, ((Project)this.getFaceted()).getRoot().getFullyQualifiedName());
                int returnCode = new MavenCli().doMain(cliRequest);
                bl = returnCode == 0;
            }
            catch (Throwable throwable) {
                System.setOut(oldout);
                System.setErr(olderr);
                throw throwable;
            }
            System.setOut(oldout);
            System.setErr(olderr);
            return bl;
        }
        finally {
            globalLogger.removeHandler(outHandler);
        }
    }

    CliRequest createCliRequest(String[] params, String workingDirectory) {
        CliRequest cliRequest = null;
        try {
            Constructor constructor = CliRequest.class.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = (CliRequest)constructor.newInstance(params, null);
            Field workingDirectoryField = CliRequest.class.getDeclaredField("workingDirectory");
            workingDirectoryField.setAccessible(true);
            workingDirectoryField.set(cliRequest, workingDirectory);
            Field multiModuleProjectDirectoryField = CliRequest.class.getDeclaredField("multiModuleProjectDirectory");
            multiModuleProjectDirectoryField.setAccessible(true);
            multiModuleProjectDirectoryField.set(cliRequest, new File(workingDirectory));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating CliRequest", e);
        }
        return cliRequest;
    }

    public boolean executeMaven(List<String> parameters) {
        return this.executeMaven(parameters.toArray(new String[parameters.size()]));
    }

    public boolean executeMaven(String[] selected) {
        return this.executeMaven(System.out, selected);
    }

    public boolean executeMaven(OutputStream out, String[] arguments) {
        ArrayList<String> list = new ArrayList<String>();
        if (System.getProperty("org.apache.maven.user-settings") != null) {
            list.add("-s");
            list.add(System.getProperty("org.apache.maven.user-settings"));
        } else if (System.getProperty("org.apache.maven.global-settings") != null) {
            list.add("-s");
            list.add(System.getProperty("org.apache.maven.global-settings"));
        }
        if (arguments != null) {
            list.addAll(Arrays.asList(arguments));
        }
        String[] params = list.toArray(new String[list.size()]);
        try {
            DirectoryResource directory = (DirectoryResource)((Project)this.getFaceted()).getRoot().reify(DirectoryResource.class);
            if (directory == null) {
                throw new IllegalStateException("Cannot execute maven build on resources that are not File-based.");
            }
            int returnValue = NativeSystemCall.execFromPath(this.getMvnCommand(), params, out, directory);
            if (returnValue == 0) {
                return true;
            }
            return this.executeMavenEmbedded(params);
        }
        catch (IOException e) {
            return this.executeMavenEmbedded(params);
        }
    }

    private String getMvnCommand() {
        return OperatingSystemUtils.isWindows() ? "mvn.bat" : "mvn";
    }

    public DirectoryResource getLocalRepositoryDirectory() {
        ResourceFactory resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ResourceFactory.class).get();
        return (DirectoryResource)resourceFactory.create((Object)BUILD_MANAGER.getLocalRepositoryDirectory()).reify(DirectoryResource.class);
    }

    public boolean isModelValid() {
        try {
            boolean valid = true;
            List problems = this.getProjectBuildingResult().getProblems();
            for (ModelProblem problem : problems) {
                valid &= ModelProblem.Severity.WARNING.equals((Object)problem.getSeverity());
            }
            return valid;
        }
        catch (ProjectBuildingException e) {
            return false;
        }
    }

    private static class UncloseableStreamHandler
    extends Handler {
        private final PrintStream out;
        private final boolean quiet;

        public UncloseableStreamHandler(PrintStream out, boolean quiet) {
            this.out = out;
            this.quiet = quiet;
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.quiet && this.isLoggable(record)) {
                this.out.printf("[%s] %s%n", record.getLevel(), record.getMessage());
            }
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            if (super.isLoggable(record)) {
                return !UnsupportedSlf4jBindingConfiguration.class.getName().equals(record.getLoggerName());
            }
            return false;
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
        }
    }
}

