/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import java.io.File;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.projects.archetype.ArchetypeHelper;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

public abstract class AbstractArchetypeSelectionWizardStep
extends AbstractUICommand
implements UIWizardStep {
    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = (Project)uiContext.getAttributeMap().get(Project.class);
        String coordinate = this.getArchetypeGroupId() + ":" + this.getArchetypeArtifactId() + ":" + this.getArchetypeVersion();
        DependencyQueryBuilder depQuery = DependencyQueryBuilder.create((String)coordinate);
        String repository = this.getArchetypeRepository();
        if (repository != null) {
            depQuery.setRepositories(new DependencyRepository[]{new DependencyRepository("archetype", repository)});
        }
        DependencyResolver resolver = (DependencyResolver)SimpleContainer.getServices((ClassLoader)AbstractArchetypeSelectionWizardStep.class.getClassLoader(), DependencyResolver.class).get();
        Dependency resolvedArtifact = resolver.resolveArtifact((DependencyQuery)depQuery);
        FileResource artifact = resolvedArtifact.getArtifact();
        MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
        File fileRoot = (File)((DirectoryResource)project.getRoot().reify(DirectoryResource.class)).getUnderlyingResourceObject();
        ArchetypeHelper archetypeHelper = new ArchetypeHelper(artifact.getResourceInputStream(), fileRoot, metadataFacet.getProjectGroupName(), metadataFacet.getProjectName(), metadataFacet.getProjectVersion());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        archetypeHelper.setPackageName(facet.getBasePackage());
        archetypeHelper.execute();
        return Results.success();
    }

    protected abstract String getArchetypeRepository();

    protected abstract String getArchetypeVersion();

    protected abstract String getArchetypeArtifactId();

    protected abstract String getArchetypeGroupId();
}

