/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.furnace.util.Assert;

@FacetConstraint(value={MavenFacet.class})
public class MavenJavaCompilerFacet
extends AbstractFacet<Project>
implements JavaCompilerFacet {
    static final String MAVEN_COMPILER_SOURCE_KEY = "maven.compiler.source";
    static final String MAVEN_COMPILER_TARGET_KEY = "maven.compiler.target";
    static final String MAVEN_COMPILER_ENCODING_KEY = "project.build.sourceEncoding";

    public boolean isInstalled() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        List<String> keys = Arrays.asList(MAVEN_COMPILER_SOURCE_KEY, MAVEN_COMPILER_TARGET_KEY, MAVEN_COMPILER_ENCODING_KEY);
        return properties.keySet().containsAll(keys);
    }

    public boolean install() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        this.setMavenCompilerSource(properties, DEFAULT_COMPILER_VERSION.toString());
        this.setMavenCompilerTarget(properties, DEFAULT_COMPILER_VERSION.toString());
        properties.setProperty(MAVEN_COMPILER_ENCODING_KEY, "UTF-8");
        maven.setModel(pom);
        return true;
    }

    public void setSourceCompilerVersion(JavaCompilerFacet.CompilerVersion version) {
        Assert.notNull((Object)version, (String)"The source compiler version must not be null");
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        this.setMavenCompilerSource(pom.getProperties(), version.toString());
        maven.setModel(pom);
    }

    public void setTargetCompilerVersion(JavaCompilerFacet.CompilerVersion version) {
        Assert.notNull((Object)version, (String)"The target compiler version must not be null");
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        this.setMavenCompilerTarget(pom.getProperties(), version.toString());
        maven.setModel(pom);
    }

    public JavaCompilerFacet.CompilerVersion getSourceCompilerVersion() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        String sourceVersion = pom.getProperties().getProperty(MAVEN_COMPILER_SOURCE_KEY);
        return sourceVersion != null ? JavaCompilerFacet.CompilerVersion.getValue((String)sourceVersion) : DEFAULT_COMPILER_VERSION;
    }

    public JavaCompilerFacet.CompilerVersion getTargetCompilerVersion() {
        MavenFacet maven = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        String targetVersion = pom.getProperties().getProperty(MAVEN_COMPILER_TARGET_KEY);
        return targetVersion != null ? JavaCompilerFacet.CompilerVersion.getValue((String)targetVersion) : DEFAULT_COMPILER_VERSION;
    }

    private Properties setMavenCompilerSource(Properties mavenProps, String sourceCompilerVersion) {
        mavenProps.setProperty(MAVEN_COMPILER_SOURCE_KEY, sourceCompilerVersion);
        return mavenProps;
    }

    private void setMavenCompilerTarget(Properties mavenProps, String targetCompilerVersion) {
        mavenProps.setProperty(MAVEN_COMPILER_TARGET_KEY, targetCompilerVersion);
    }
}

