/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.parser.java.facets.JavaTargetFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.DirectoryResource;

@FacetConstraint(value={MavenFacet.class, PackagingFacet.class})
public class MavenJavaTargetFacet
extends AbstractFacet<Project>
implements JavaTargetFacet {
    public List<DirectoryResource> getTargetDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getTargetDirectory());
        result.add(this.getTestTargetDirectory());
        return result;
    }

    public DirectoryResource getTargetDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String targetFolderName = build != null && build.getOutputDirectory() != null ? mavenFacet.resolveProperties(build.getOutputDirectory()) : "target" + File.separator + "classes";
        DirectoryResource projectRoot = (DirectoryResource)((Project)this.getFaceted()).getRoot().reify(DirectoryResource.class);
        return projectRoot.getChildDirectory(targetFolderName);
    }

    public DirectoryResource getTestTargetDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String targetFolderName = build != null && build.getTestOutputDirectory() != null ? mavenFacet.resolveProperties(build.getTestOutputDirectory()) : "target" + File.separator + "test-classes";
        DirectoryResource projectRoot = (DirectoryResource)((Project)this.getFaceted()).getRoot().reify(DirectoryResource.class);
        return projectRoot.getChildDirectory(targetFolderName);
    }

    public boolean install() {
        PackagingFacet packagingFacet = (PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class);
        packagingFacet.createBuilder().quiet(true).runTests(false).build();
        return this.isInstalled();
    }

    public boolean isInstalled() {
        return this.getTargetDirectory().exists();
    }
}

