/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.core.CollectionAndSequence;
import freemarker.ext.beans.BeanModel;
import freemarker.template.DefaultListAdapter;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;

public class IterableHasContent
implements WindupFreeMarkerMethod {
    private static final String NAME = "iterableHasContent";

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        try {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Error, method expects one argument (Iterable)");
            }
            Boolean bl = this.hasContent(arguments.get(0));
            return bl;
        }
        finally {
            ExecutionStatistics.get().end(NAME);
        }
    }

    private boolean hasContent(Object arg) throws TemplateModelException {
        if (arg instanceof BeanModel) {
            BeanModel beanModel = (BeanModel)arg;
            return ((Iterable)beanModel.getWrappedObject()).iterator().hasNext();
        }
        if (arg instanceof SimpleSequence) {
            SimpleSequence simpleSequence = (SimpleSequence)arg;
            return simpleSequence.toList().size() > 0;
        }
        if (arg instanceof DefaultListAdapter) {
            DefaultListAdapter defaultListAdapter = (DefaultListAdapter)arg;
            return defaultListAdapter.size() > 0;
        }
        if (arg instanceof CollectionAndSequence) {
            CollectionAndSequence sequence = (CollectionAndSequence)arg;
            return sequence.size() > 0;
        }
        throw new WindupException("Unrecognized type passed to: " + this.getMethodName() + ": " + arg.getClass().getCanonicalName());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable as a parameter and checks to see whether items exist in the Iterable.";
    }

    public void setContext(GraphRewrite event) {
    }
}

