/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.addon.resource.AbstractFileResource;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class DirectoryResourceImpl
extends AbstractFileResource<DirectoryResource>
implements DirectoryResource {
    private volatile List<Resource<?>> listCache;

    public DirectoryResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
        this.isStale();
    }

    protected List<Resource<?>> doListResources() {
        if (this.isStale()) {
            this.listCache = null;
        }
        if (this.listCache == null) {
            this.refresh();
            this.listCache = new LinkedList();
            File[] files = this.getFileOperations().listFiles(this.getUnderlyingResourceObject());
            if (files != null) {
                for (File f : files) {
                    this.listCache.add(this.getResourceFactory().create((Object)f));
                }
            }
        }
        return this.listCache;
    }

    public Resource<?> getChild(String name) {
        return this.getResourceFactory().create((Object)new File(this.getUnderlyingResourceObject().getAbsolutePath(), name));
    }

    public DirectoryResourceImpl getChildDirectory(String name) throws ResourceException {
        Object result = this.getChild(name);
        if (!(result instanceof DirectoryResourceImpl) && result.exists()) {
            throw new ResourceException("The resource [" + result.getFullyQualifiedName() + "] is not a DirectoryResource");
        }
        if (!(result instanceof DirectoryResourceImpl)) {
            result = new DirectoryResourceImpl(this.getResourceFactory(), new File(this.getUnderlyingResourceObject().getAbsoluteFile(), name));
        }
        return (DirectoryResourceImpl)((Object)result);
    }

    public DirectoryResourceImpl getOrCreateChildDirectory(String name) {
        DirectoryResourceImpl child = this.getChildDirectory(name);
        if (!child.exists()) {
            child.mkdirs();
        }
        return child;
    }

    public <E, T extends Resource<E>> T getChildOfType(Class<T> type, String name) throws ResourceException {
        Resource result;
        Resource child = this.getChild(name);
        if (type.isAssignableFrom(child.getClass())) {
            result = child;
        } else {
            if (child.exists()) {
                throw new ResourceException("Requested resource [" + name + "] was not of type [" + type.getName() + "], but was instead [" + child.getClass().getName() + "]");
            }
            Object underlyingResource = child.getUnderlyingResourceObject();
            result = this.getResourceFactory().create(type, underlyingResource);
        }
        return (T)result;
    }

    public DirectoryResourceImpl createTempResource() {
        try {
            File tempFile = File.createTempFile("forgetemp", "");
            tempFile.delete();
            return this.createFrom(tempFile);
        }
        catch (IOException e) {
            throw new ResourceException("Error while creating temporary directory", (Throwable)e);
        }
    }

    public DirectoryResourceImpl createFrom(File file) {
        if (this.getFileOperations().fileExists(file) && !this.getFileOperations().fileExistsAndIsDirectory(file)) {
            throw new ResourceException("File reference is not a directory: " + file.getAbsolutePath());
        }
        if (!this.getFileOperations().fileExists(file)) {
            this.getFileOperations().mkdirs(file);
        }
        return new DirectoryResourceImpl(this.getResourceFactory(), file);
    }

    public synchronized DirectoryResource getParent() {
        if (super.getParent() == null) {
            File parentFile = this.getUnderlyingResourceObject().getParentFile();
            if (parentFile == null) {
                return null;
            }
            super.setParent((Resource)this.createFrom(parentFile));
        }
        return super.getParent();
    }

    public String getName() {
        String fileName = this.getUnderlyingResourceObject().getName();
        return OperatingSystemUtils.isWindows() && fileName.length() == 0 ? this.getUnderlyingResourceObject().getPath() : fileName;
    }

    public boolean equals(Object obj) {
        return obj instanceof DirectoryResourceImpl && ((DirectoryResourceImpl)((Object)obj)).getUnderlyingResourceObject().equals(this.getUnderlyingResourceObject());
    }

    public long getSize() {
        throw new UnsupportedOperationException("getSize not supported for DirectoryResource objects");
    }

    public DirectoryResource setContents(char[] data) {
        throw new UnsupportedOperationException("setContents(char[]) is not supported on DirectoryResource objects");
    }

    public DirectoryResource setContents(InputStream data) {
        throw new UnsupportedOperationException("setContents(InputStream) is not supported on DirectoryResource objects");
    }

    public DirectoryResource setContents(String data) {
        throw new UnsupportedOperationException("Is a directory");
    }

    public String getContents() {
        throw new UnsupportedOperationException("Is a directory");
    }

    public DirectoryResource setContents(char[] data, Charset charset) {
        throw new UnsupportedOperationException("setContents(char[], Charset) is not supported on DirectoryResource objects");
    }

    public DirectoryResource setContents(String data, Charset charset) {
        throw new UnsupportedOperationException("setContents(String, Charset) is not supported on DirectoryResource objects");
    }

    public String getContents(Charset charset) {
        throw new UnsupportedOperationException("getContents(Charset) is not supported on DirectoryResource objects");
    }

    public OutputStream getResourceOutputStream() {
        throw new UnsupportedOperationException("getResourceOutputStream() is not supported on DirectoryResource objects");
    }
}

