/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.xml;

import java.io.IOException;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.reporting.service.TagSetService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.xml.InvalidXSDURLException;
import org.jboss.windup.rules.apps.xml.xml.ValidateXmlHandler;
import org.jboss.windup.rules.files.condition.ProcessingIsOnlineGraphCondition;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXmlFilesRuleProvider
extends AbstractRuleProvider {
    public static final String NOT_VALID_XML_TAG = "Not valid XML";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    public ValidateXmlFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ValidateXmlFilesRuleProvider.class).setPhase(MigrationRulesPhase.class).setHaltOnException(true));
    }

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)new ProcessingIsOnlineGraphCondition().and((Condition)Query.fromType(XmlFileModel.class))).perform((Operation)new ValidateAndRegisterClassification());
    }

    private void createParseFailureClassification(GraphRewrite event, EvaluationContext context, XmlFileModel sourceFile) {
        sourceFile.setGenerateSourceReport(true);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        ClassificationModel model = classificationService.attachClassification(event, context, (FileModel)sourceFile, "XML File is not valid", null);
        model.setEffort(0);
        IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)event.getRewriteContext());
        model.setIssueCategory(IssueCategoryRegistry.loadFromGraph((GraphContext)event.getGraphContext(), (String)"potential"));
        TagSetService tagSetService = new TagSetService(event.getGraphContext());
        model.setTagModel(tagSetService.getOrCreate(event, Collections.singleton(NOT_VALID_XML_TAG)));
    }

    private class ValidateAndRegisterClassification
    extends AbstractIterationOperation<XmlFileModel> {
        private ValidateAndRegisterClassification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel sourceFile) {
            boolean onlineMode = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext()).isOnlineMode();
            boolean validationFailed = false;
            try {
                if (StringUtils.isNotBlank((CharSequence)sourceFile.getParseError())) {
                    return;
                }
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                factory.setXIncludeAware(false);
                SAXParser parser = factory.newSAXParser();
                parser.setProperty(ValidateXmlFilesRuleProvider.JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
                ValidateXmlHandler handler = new ValidateXmlHandler(onlineMode);
                parser.parse(sourceFile.asFile(), (DefaultHandler)handler);
                if (!handler.getXsdURLs().isEmpty()) {
                    for (SAXParseException exception : handler.getParseExceptions()) {
                        if (!this.isExceptionRelatedToSource(sourceFile, exception)) continue;
                        validationFailed = true;
                        this.createSAXParseHint(event, context, sourceFile, exception);
                    }
                }
            }
            catch (SAXParseException e) {
                if (this.isExceptionRelatedToSource(sourceFile, e)) {
                    validationFailed = true;
                    this.createSAXParseHint(event, context, sourceFile, e);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                validationFailed = true;
            }
            finally {
                if (validationFailed) {
                    ValidateXmlFilesRuleProvider.this.createParseFailureClassification(event, context, sourceFile);
                }
            }
        }

        private boolean isExceptionRelatedToSource(XmlFileModel sourceFile, SAXParseException e) {
            if (e.getSystemId() == null) {
                return true;
            }
            if (e.getSystemId().startsWith("http://") || e.getSystemId().startsWith("https://") || e.getSystemId().startsWith("ftp://")) {
                return false;
            }
            return e.getSystemId().endsWith(sourceFile.getFileName());
        }

        private void createSAXParseHint(GraphRewrite event, EvaluationContext context, XmlFileModel sourceFile, SAXParseException e) {
            int lineNumber = e.getLineNumber();
            int column = e.getColumnNumber();
            InlineHintService service = new InlineHintService(event.getGraphContext());
            InlineHintModel hintModel = (InlineHintModel)service.create();
            hintModel.setRuleID(((Rule)context.get(Rule.class)).getId());
            hintModel.setLineNumber(lineNumber);
            hintModel.setColumnNumber(column);
            hintModel.setLength(1);
            hintModel.setFile((FileModel)sourceFile);
            hintModel.setEffort(1);
            IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)event.getRewriteContext());
            hintModel.setIssueCategory(IssueCategoryRegistry.loadFromGraph((GraphContext)event.getGraphContext(), (String)"potential"));
            if (e.getCause() instanceof InvalidXSDURLException) {
                String xsdUrl = ((InvalidXSDURLException)e.getCause()).getUrl();
                hintModel.setTitle("XML File references not valid xsd url.");
                hintModel.setHint(xsdUrl + " is not a valid url.");
            } else {
                hintModel.setTitle("XML File is not valid");
                String message = "XSD Validation failed due to:\n\n";
                message = message + "\t" + e.getMessage();
                message = message + "\n\n";
                hintModel.setHint(message);
            }
            sourceFile.setGenerateSourceReport(true);
        }
    }
}

