/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.files.condition.FileContent;
import org.jboss.windup.rules.files.condition.FileContentFrom;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="filecontent", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class FileContentHandler
implements ElementHandler<FileContent> {
    public static final String ELEM_NAME = "filecontent";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_FILENAME = "filename";
    private static final String ATTR_FROM = "from";
    private static final Logger LOG = Logging.get(FileContentHandler.class);

    public FileContent processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String contentPattern = JOOX.$((Element)element).attr(ATTR_PATTERN);
        String filenamePattern = JOOX.$((Element)element).attr(ATTR_FILENAME);
        String from = JOOX.$((Element)element).attr(ATTR_FROM);
        String as = JOOX.$((Element)element).attr("as");
        if (as == null) {
            as = "default";
        }
        if (StringUtils.isBlank((CharSequence)contentPattern)) {
            throw new WindupException("The 'filecontent' element must have a non-empty 'pattern' attribute");
        }
        Object obj = null;
        obj = this.applyFrom(obj, from);
        obj = this.applyMatches(obj, contentPattern);
        obj = this.applyFileName(obj, filenamePattern);
        FileContent f = (FileContent)obj;
        f.as(as);
        if (StringUtils.isBlank((CharSequence)from) && StringUtils.isBlank((CharSequence)filenamePattern)) {
            LOG.warning("One of the filecontent conditions (" + f.toString() + ") is scanning all the files for a regex. This may havesignificant performance overhead.");
        }
        return f;
    }

    private Object applyFrom(Object fileContentBuilder, String from) {
        if (from != null) {
            fileContentBuilder = FileContent.from(from);
        }
        return fileContentBuilder;
    }

    private Object applyMatches(Object fileContentBuilder, String contentPattern) {
        if (contentPattern != null) {
            fileContentBuilder = fileContentBuilder == null ? FileContent.matches(contentPattern) : ((FileContentFrom)fileContentBuilder).matches(contentPattern);
        }
        return fileContentBuilder;
    }

    private Object applyFileName(Object fileContentBuilder, String fileName) {
        if (fileName != null && fileContentBuilder != null) {
            fileContentBuilder = ((FileContent)fileContentBuilder).inFileNamed(fileName);
        }
        return fileContentBuilder;
    }
}

