/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceTransformerLoader;

public class TechnologyReferenceTransformer {
    private static final String KEY = TechnologyReferenceTransformer.class.getCanonicalName();
    private final TechnologyReference original;
    private final TechnologyReference target;

    public TechnologyReferenceTransformer(TechnologyReference original, TechnologyReference target) {
        this.original = original;
        this.target = target;
    }

    public static List<TechnologyReferenceTransformer> getTransformers(RuleLoaderContext ruleLoaderContext) {
        ArrayList<TechnologyReferenceTransformer> transformerList = new ArrayList<TechnologyReferenceTransformer>();
        Imported loaders = FurnaceHolder.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(TechnologyReferenceTransformerLoader.class);
        loaders.forEach(loader -> transformerList.addAll(loader.loadTransformers(ruleLoaderContext)));
        return transformerList;
    }

    public TechnologyReference getOriginal() {
        return this.original;
    }

    public TechnologyReference getTarget() {
        return this.target;
    }

    public TechnologyReference transform(TechnologyReference reference) {
        if (this.original.matches(reference)) {
            return this.target;
        }
        return reference;
    }

    public TechnologyReference transform(String idAndVersion) {
        TechnologyReference reference = TechnologyReference.parseFromIDAndVersion(idAndVersion);
        if (this.original.matches(reference)) {
            return this.target;
        }
        return reference;
    }
}

