/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation.iteration;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.ocpsoft.rewrite.context.EvaluationContext;

public abstract class AbstractIterationOperation<T extends WindupVertexFrame>
extends GraphOperation {
    private String variableName;

    public AbstractIterationOperation() {
    }

    public AbstractIterationOperation(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return null;
        }
        return new VariableNameIterator(this.variableName).next();
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean hasVariableNameSet() {
        return this.getVariableName() != null;
    }

    @Override
    public void perform(GraphRewrite event, EvaluationContext context) {
        this.checkVariableName(event, context);
        WindupVertexFrame payload = this.resolveVariable(event, this.variableName);
        this.perform(event, context, this.resolvePayload(event, context, payload));
    }

    public T resolvePayload(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        return (T)payload;
    }

    protected void checkVariableName(GraphRewrite event, EvaluationContext context) {
        if (this.variableName == null) {
            this.setVariableName(Iteration.getPayloadVariableName(event, context));
        }
    }

    protected WindupVertexFrame resolveVariable(GraphRewrite event, String variableName) {
        Object payload;
        Variables variables = Variables.instance(event);
        VariableNameIterator tokenizer = new VariableNameIterator(variableName);
        String initialName = (String)tokenizer.next();
        try {
            payload = Iteration.getCurrentPayload(variables, initialName);
        }
        catch (IllegalArgumentException e1) {
            payload = variables.findSingletonVariable(initialName);
        }
        while (tokenizer.hasNext()) {
            String propertyName = (String)tokenizer.next();
            propertyName = "get" + this.camelCase(propertyName, true, new char[0]);
            try {
                payload = (WindupVertexFrame)payload.getClass().getMethod(propertyName, new Class[0]).invoke(payload, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Invalid variable expression: " + variableName, e);
            }
        }
        return payload;
    }

    public abstract void perform(GraphRewrite var1, EvaluationContext var2, T var3);

    public String camelCase(String lowerCaseAndUnderscoredWord, boolean uppercaseFirstLetter, char ... delimiterChars) {
        if (lowerCaseAndUnderscoredWord == null) {
            return null;
        }
        if ((lowerCaseAndUnderscoredWord = lowerCaseAndUnderscoredWord.trim()).length() == 0) {
            return "";
        }
        if (uppercaseFirstLetter) {
            String result = lowerCaseAndUnderscoredWord;
            if (delimiterChars != null) {
                for (char delimiterChar : delimiterChars) {
                    result = result.replace(delimiterChar, '_');
                }
            }
            return this.replaceAllWithUppercase(result, "(^|_)(.)", 2);
        }
        if (lowerCaseAndUnderscoredWord.length() < 2) {
            return lowerCaseAndUnderscoredWord;
        }
        return "" + Character.toLowerCase(lowerCaseAndUnderscoredWord.charAt(0)) + this.camelCase(lowerCaseAndUnderscoredWord, true, delimiterChars).substring(1);
    }

    String replaceAllWithUppercase(String input, String regex, int groupNumberToUppercase) {
        Pattern underscoreAndDotPattern = Pattern.compile(regex);
        Matcher matcher = underscoreAndDotPattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(groupNumberToUppercase).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " with var '" + this.variableName + "'";
    }

    private static class VariableNameIterator
    implements Iterator<String> {
        final Queue<String> queue;

        public VariableNameIterator(String name) {
            String result = name;
            if (name.trim().startsWith("#{")) {
                result = result.replaceAll("\\s*#\\{\\s*([a-zA-Z0-9.]+)\\s*\\}\\s*", "$1");
                result = result.replaceAll("([a-zA-Z0-9]+\\..*)", "$1");
            }
            this.queue = new LinkedList<String>(Arrays.asList(result.split("\\.")));
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public String next() {
            return this.queue.remove();
        }

        @Override
        public void remove() {
            this.queue.poll();
        }
    }
}

