/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.tags;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.set.UnmodifiableSet;

public final class Tag {
    private final String name;
    private final Set<Tag> containedTags = new HashSet<Tag>();
    private final Set<Tag> parentTags = new HashSet<Tag>();
    private boolean isRoot = false;
    private boolean isPseudo = false;
    private String color = null;
    private String title = null;

    Tag(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Tag name must not be null.");
        }
        this.name = name.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public Set<Tag> getContainedTags() {
        return UnmodifiableSet.unmodifiableSet(this.containedTags);
    }

    public Set<Tag> getParentTags() {
        return UnmodifiableSet.unmodifiableSet(this.parentTags);
    }

    public void addContainedTag(Tag tag) {
        this.containedTags.add(tag);
        tag.parentTags.add(this);
    }

    public void addContainingTag(Tag tag) {
        this.parentTags.add(tag);
        tag.containedTags.add(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.name, other.name);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public void setPseudo(boolean isPseudo) {
        this.isPseudo = isPseudo;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTitleOrName() {
        return this.title != null ? this.title : this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

