/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModelException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetEffortCountForProjectBySeverityMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "getEffortCountForProjectBySeverity";
    private ClassificationService classificationService;
    private InlineHintService inlineHintService;

    public void setContext(GraphRewrite event) {
        this.classificationService = new ClassificationService(event.getGraphContext());
        this.inlineHintService = new InlineHintService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a " + ProjectModel.class.getSimpleName() + " as a parameter and returns Map<String, int> where the key is the Severity and the value is the number of incidents of that severity.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() < 2) {
            throw new TemplateModelException("Error, method expects at least two arguments (projectModel:ProjectModel, recursive:Boolean, [includeTags:Set<String>]. [excludeTags:Set<String>])");
        }
        StringModel projectModelTraversalArg = (StringModel)arguments.get(0);
        ProjectModelTraversal traversal = (ProjectModelTraversal)projectModelTraversalArg.getWrappedObject();
        TemplateBooleanModel recursiveBooleanModel = (TemplateBooleanModel)arguments.get(1);
        boolean recursive = recursiveBooleanModel.getAsBoolean();
        Set includeTags = Collections.emptySet();
        if (arguments.size() >= 3) {
            includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(2)));
        }
        Set excludeTags = Collections.emptySet();
        if (arguments.size() >= 4) {
            excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)((SimpleSequence)arguments.get(3)));
        }
        Map classificationEffortDetails = this.classificationService.getMigrationEffortBySeverity(traversal, includeTags, excludeTags, recursive);
        Map hintEffortDetails = this.inlineHintService.getMigrationEffortBySeverity(traversal, includeTags, excludeTags, recursive);
        HashMap<String, Integer> results = new HashMap<String, Integer>(classificationEffortDetails.size() + hintEffortDetails.size());
        this.addAllIncidents(results, classificationEffortDetails);
        this.addAllIncidents(results, hintEffortDetails);
        ExecutionStatistics.get().end(NAME);
        return results;
    }

    private void addAllIncidents(Map<String, Integer> results, Map<Severity, Integer> effortDetails) {
        for (Map.Entry<Severity, Integer> entry : effortDetails.entrySet()) {
            if (!results.containsKey(entry.getKey().toString())) {
                results.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            results.put(entry.getKey().toString(), results.get(entry.getKey().toString()) + entry.getValue());
        }
    }
}

