/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;
import org.jboss.windup.reporting.model.Severity;

public class GetProblemSummariesMethod
implements WindupFreeMarkerMethod {
    public static final String NAME = "getProblemSummaries";
    private GraphContext context;

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Returns a summary of all classification and hints found during analysis in the form of a List<" + ProblemSummary.class.getSimpleName() + ">.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        StringModel projectModelArg;
        ProjectModel projectModel = arguments.size() > 0 ? ((projectModelArg = (StringModel)arguments.get(0)) == null ? null : (ProjectModel)projectModelArg.getWrappedObject()) : null;
        Set<String> includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(1));
        Set<String> excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(2));
        Set<ProjectModel> projectModels = this.getProjects(projectModel);
        Map<Severity, List<ProblemSummary>> problemSummariesOriginal = ProblemSummaryService.getProblemSummaries(this.context, projectModels, includeTags, excludeTags);
        Comparator<Severity> severityComparator = new Comparator<Severity>(){

            @Override
            public int compare(Severity severity1, Severity severity2) {
                int ordinal1 = severity1 == null ? 0 : severity1.ordinal();
                int ordinal2 = severity2 == null ? 0 : severity2.ordinal();
                return ordinal1 - ordinal2;
            }
        };
        TreeMap<Severity, List<ProblemSummary>> problemSummaries = new TreeMap<Severity, List<ProblemSummary>>(severityComparator);
        problemSummaries.putAll(problemSummariesOriginal);
        LinkedHashMap primarySummariesByString = new LinkedHashMap(problemSummariesOriginal.size());
        for (Map.Entry entry : problemSummaries.entrySet()) {
            String severityString = entry.getKey() == null ? null : ((Severity)((Object)entry.getKey())).toString();
            primarySummariesByString.put(severityString, entry.getValue());
        }
        return primarySummariesByString;
    }

    private Set<ProjectModel> getProjects(ProjectModel projectModel) {
        if (projectModel == null) {
            return null;
        }
        ProjectModelTraversal traversal = new ProjectModelTraversal(projectModel, (TraversalStrategy)new OnlyOnceTraversalStrategy());
        return traversal.getAllProjects(true);
    }

    @Override
    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }
}

