/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClassFileReader;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.VerifyArgument;
import org.apache.commons.collections4.map.LRUMap;

public final class NoRetryMetadataSystem
extends MetadataSystem {
    private static final TypeDefinition[] PRIMITIVE_TYPES_BY_NAME = new TypeDefinition[25];
    private static final TypeDefinition[] PRIMITIVE_TYPES_BY_DESCRIPTOR = new TypeDefinition[16];
    private final LRUMap<String, Boolean> failedTypes = new LRUMap(1000);
    private final LRUMap<String, TypeDefinition> resolvedTypes = new LRUMap(1000);
    private final ITypeLoader typeLoader;

    public NoRetryMetadataSystem(ITypeLoader typeLoader) {
        super(typeLoader);
        this.typeLoader = typeLoader;
    }

    public void addTypeDefinition(TypeDefinition type) {
        VerifyArgument.notNull((Object)type, (String)"type");
        this.resolvedTypes.put((Object)type.getInternalName(), (Object)type);
    }

    protected TypeDefinition resolveType(String descriptor, boolean mightBePrimitive) {
        if (this.failedTypes.containsKey((Object)descriptor)) {
            return null;
        }
        TypeDefinition result = this.resolveTypeInternal(descriptor, mightBePrimitive);
        if (result == null) {
            this.failedTypes.put((Object)descriptor, (Object)true);
        }
        return result;
    }

    protected TypeDefinition resolveTypeInternal(String descriptor, boolean mightBePrimitive) {
        TypeDefinition primitiveType;
        int primitiveHash;
        VerifyArgument.notNull((Object)descriptor, (String)"descriptor");
        if (mightBePrimitive && (descriptor.length() == 1 ? (primitiveHash = descriptor.charAt(0) - 66) >= 0 && primitiveHash < PRIMITIVE_TYPES_BY_DESCRIPTOR.length && (primitiveType = PRIMITIVE_TYPES_BY_DESCRIPTOR[primitiveHash]) != null : (primitiveHash = NoRetryMetadataSystem.hashPrimitiveName(descriptor)) >= 0 && primitiveHash < PRIMITIVE_TYPES_BY_NAME.length && (primitiveType = PRIMITIVE_TYPES_BY_NAME[primitiveHash]) != null && descriptor.equals(primitiveType.getName()))) {
            return primitiveType;
        }
        TypeDefinition cachedDefinition = (TypeDefinition)this.resolvedTypes.get((Object)descriptor);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        Buffer buffer = new Buffer(0);
        if (!this.typeLoader.tryLoadType(descriptor, buffer)) {
            return null;
        }
        TypeDefinition typeDefinition = ClassFileReader.readClass((int)1, (IMetadataResolver)this, (Buffer)buffer);
        cachedDefinition = (TypeDefinition)this.resolvedTypes.put((Object)descriptor, (Object)typeDefinition);
        typeDefinition.setTypeLoader(this.typeLoader);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        return typeDefinition;
    }

    private static int hashPrimitiveName(String name) {
        if (name.length() < 3) {
            return 0;
        }
        return (name.charAt(0) + name.charAt(2)) % 16;
    }
}

