/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.branch.CopySplitPipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import com.tinkerpop.pipes.sideeffect.AggregatePipe;
import com.tinkerpop.pipes.sideeffect.GroupCountPipe;
import com.tinkerpop.pipes.transform.OutPipe;
import com.tinkerpop.pipes.transform.PropertyPipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.util.Logging;

public class ModuleAnalysisHelper {
    public static final String LAST_RESORT_DEFAULT_GROUP_ID = "com.mycompany.mavenized";
    private static final Logger LOG = Logging.get(ModuleAnalysisHelper.class);
    protected GraphContext graphContext;

    public ModuleAnalysisHelper(GraphContext context) {
        this.graphContext = context;
    }

    String deriveGroupId(ProjectModel projectModel) {
        List scanPackages;
        String groupId;
        if (projectModel instanceof MavenProjectModel) {
            MavenProjectModel mavenProject = (MavenProjectModel)projectModel;
            mavenProject.getGroupId();
        }
        if ((groupId = (String)this.graphContext.getOptionMap().get("mavenizeGroupId")) != null) {
            if (groupId.matches("[a-zA-Z][-_a-zA-Z0-9]*(\\.[a-zA-Z][-_a-zA-Z0-9]*)*")) {
                return groupId;
            }
            LOG.severe("mavenizeGroupId doesn't match the groupId pattern, ignoring: " + groupId);
        }
        if ((scanPackages = (List)this.graphContext.getOptionMap().get("packages")) != null && !scanPackages.isEmpty() && ((String)scanPackages.get(0)).contains(".")) {
            return (String)scanPackages.get(0);
        }
        return LAST_RESORT_DEFAULT_GROUP_ID;
    }

    String deriveGroupIdFromPackages(ProjectModel projectModel) {
        HashMap pkgsMap = new HashMap();
        HashSet pkgs = new HashSet(1000);
        GremlinPipeline pipeline = new GremlinPipeline((Object)projectModel);
        PipeFunction<String, String> upToThirdDot = new PipeFunction<String, String>(){

            public String compute(String pkgName) {
                int upToThirdDot = StringUtils.ordinalIndexOf((CharSequence)pkgName, (CharSequence)".", (int)3);
                return StringUtils.substring((String)pkgName, (int)0, (int)upToThirdDot);
            }
        };
        PipeFunction<String, String> identity = new PipeFunction<String, String>(){

            public String compute(String pkgName) {
                return pkgName;
            }
        };
        pipeline.add((Pipe)new OutPipe(new String[]{"projectModelToFile"})).add((Pipe)new TypePipe(JavaClassFileModel.class)).add((Pipe)new PropertyPipe("packageName")).add((Pipe)new CopySplitPipe(new Pipe[]{new AggregatePipe(pkgs, (PipeFunction)upToThirdDot), new GroupCountPipe(pkgsMap)}));
        Map.Entry biggest = null;
        for (Map.Entry entry : pkgsMap.entrySet()) {
            if (biggest != null && (Integer)biggest.getValue() >= (Integer)entry.getValue()) continue;
            biggest = entry;
        }
        if (biggest != null && (Integer)biggest.getValue() > pkgsMap.size() / 2) {
            return (String)biggest.getKey();
        }
        return null;
    }

    public class TypePipe
    extends PropertyFilterPipe<Vertex, Vertex> {
        public TypePipe(Class<? extends WindupVertexFrame> clazz) {
            super("w:winduptype", (Predicate)Text.CONTAINS, (Object)TypeAwareFramedGraphQuery.getTypeValue(clazz));
        }
    }
}

