/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.condition;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;

public class XmlFileFunctionResolver
implements XPathFunctionResolver {
    private final XPathFunctionResolver originalResolver;
    private final Map<QName, XPathFunction> functionMap = new HashMap<QName, XPathFunction>();

    public XmlFileFunctionResolver(XPathFunctionResolver originalResolver) {
        this.originalResolver = originalResolver;
    }

    public void registerFunction(String namespaceURI, String functionName, XPathFunction function) {
        QName qname = new QName(namespaceURI, functionName);
        this.functionMap.put(qname, function);
    }

    public void clearRegisteredFunctions() {
        this.functionMap.clear();
    }

    @Override
    public XPathFunction resolveFunction(final QName functionName, int arity) {
        if (this.functionMap.containsKey(functionName)) {
            return new XPathFunction(){

                public Object evaluate(List args) throws XPathFunctionException {
                    return ((XPathFunction)XmlFileFunctionResolver.this.functionMap.get(functionName)).evaluate(args);
                }
            };
        }
        return this.originalResolver.resolveFunction(functionName, arity);
    }
}

