/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.activator;

import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.activator.ActivateRequestContext;
import org.jboss.weld.context.unbound.Unbound;
import org.jboss.weld.manager.BeanManagerImpl;

@Vetoed
@Interceptor
@ActivateRequestContext
@Priority(value=1100)
public class ActivateRequestContextInterceptor {
    private final BeanManagerImpl beanManager;
    private final RequestContext requestContext;

    @Inject
    public ActivateRequestContextInterceptor(@Unbound RequestContext requestContext, BeanManagerImpl beanManager) {
        this.requestContext = requestContext;
        this.beanManager = beanManager;
    }

    @AroundInvoke
    Object invoke(InvocationContext ctx) throws Exception {
        if (this.isRequestContextActive()) {
            return ctx.proceed();
        }
        try {
            this.requestContext.activate();
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
    }

    protected boolean isRequestContextActive() {
        return this.beanManager.isContextActive(RequestScoped.class);
    }
}

