/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableSet;
import org.jboss.weld.util.collections.ImmutableHashSet;
import org.jboss.weld.util.collections.ImmutableTinySet;

public abstract class ImmutableSet<T>
extends AbstractImmutableSet<T> {
    ImmutableSet() {
    }

    public static <T> Set<T> copyOf(Collection<? extends T> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof AbstractImmutableSet) {
            return (Set)collection;
        }
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        return ImmutableSet.builder().addAll((Iterable<T>)collection).build();
    }

    public static <T> Set<T> copyOf(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof AbstractImmutableSet) {
            return (Set)iterable;
        }
        if (!iterable.iterator().hasNext()) {
            return Collections.emptySet();
        }
        return ImmutableSet.builder().addAll(iterable).build();
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        Preconditions.checkNotNull(elements);
        return ImmutableSet.builder().addAll(elements).build();
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private Set<T> set = new LinkedHashSet<T>();

        private BuilderImpl() {
        }

        @Override
        public Builder<T> add(T item) {
            if (item == null) {
                throw new IllegalArgumentException("This collection does not support null values");
            }
            this.set.add(item);
            return this;
        }

        @Override
        public Builder<T> addAll(T ... items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        public Builder<T> addAll(Iterable<? extends T> items) {
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        @Override
        public Set<T> build() {
            switch (this.set.size()) {
                case 0: {
                    return Collections.emptySet();
                }
                case 1: {
                    return new ImmutableTinySet.Singleton<Set<T>>(this.set);
                }
                case 2: {
                    return new ImmutableTinySet.Doubleton<T>(this.set);
                }
                case 3: {
                    return new ImmutableTinySet.Tripleton<T>(this.set);
                }
            }
            return new ImmutableHashSet<T>(this.set);
        }
    }

    public static interface Builder<T> {
        public Builder<T> add(T var1);

        public Builder<T> addAll(Iterable<? extends T> var1);

        public Builder<T> addAll(T ... var1);

        public Set<T> build();
    }
}

