/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.configuration.proxy;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.configuration.proxy.ProxySettings;

public class ForgeProxySelector
extends ProxySelector {
    private ProxySelector defaultProxySelector;
    private ProxySettings proxySettings;

    public ForgeProxySelector(ProxySelector defaultProxySelector, ProxySettings proxySettings) {
        this.defaultProxySelector = defaultProxySelector;
        this.proxySettings = proxySettings;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
            ArrayList<Proxy> result = new ArrayList<Proxy>();
            result.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxySettings.getProxyHost(), this.proxySettings.getProxyPort())));
            if (this.proxySettings.isAuthenticationSupported()) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ForgeProxySelector.this.proxySettings.getProxyUserName(), ForgeProxySelector.this.proxySettings.getProxyPassword().toCharArray());
                    }
                });
            }
            return result;
        }
        if (this.defaultProxySelector != null) {
            return this.defaultProxySelector.select(uri);
        }
        ArrayList<Proxy> result = new ArrayList<Proxy>();
        result.add(Proxy.NO_PROXY);
        return result;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.defaultProxySelector.connectFailed(uri, sa, ioe);
    }

    public ProxySelector getDefaultProxySelector() {
        return this.defaultProxySelector;
    }
}

