/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.regex.addons.stateful;

import com.github.rwitzel.streamflyer.regex.MatchProcessorResult;
import com.github.rwitzel.streamflyer.regex.OnStreamMatcher;
import com.github.rwitzel.streamflyer.regex.addons.stateful.State;
import com.github.rwitzel.streamflyer.regex.addons.stateful.TransitionGuard;
import com.github.rwitzel.streamflyer.regex.addons.tokens.Token;
import com.github.rwitzel.streamflyer.regex.addons.tokens.TokenProcessor;
import com.github.rwitzel.streamflyer.regex.addons.tokens.TokensMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;

public class Transitions
extends TokenProcessor {
    private State newState;
    private TransitionGuard transitionGuard;
    private List<State> endStates;
    private OnStreamMatcher matcher;

    public Transitions(List<State> endStates, TransitionGuard transitionGuard) {
        super(Transitions.mapToTokens(endStates));
        this.endStates = endStates;
        this.transitionGuard = transitionGuard;
        this.matcher = new TokensMatcher(Transitions.mapToTokens(endStates));
    }

    private static List<Token> mapToTokens(List<State> states) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (State state : states) {
            tokens.add(state.getToken());
        }
        return tokens;
    }

    private static State findStateByToken(List<State> states, Token token) {
        for (State state : states) {
            if (state.getToken() != token) continue;
            return state;
        }
        return null;
    }

    public OnStreamMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    protected MatchProcessorResult processToken(Token token, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, MatchResult matchResult) {
        State endState = Transitions.findStateByToken(this.endStates, token);
        if (endState == null) {
            throw new RuntimeException("never to happen if the class is used according to the class comment");
        }
        MatchProcessorResult stop = this.transitionGuard.stopTransition(endState, characterBuffer, firstModifiableCharacterInBuffer, matchResult);
        if (stop != null) {
            return stop;
        }
        this.newState = endState;
        return super.processToken(token, characterBuffer, firstModifiableCharacterInBuffer, matchResult);
    }

    public State pollNewState() {
        try {
            State state = this.newState;
            return state;
        }
        finally {
            this.newState = null;
        }
    }
}

