/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.NestableReport;

public class WarReport
extends NestableReport {
    private static final String DIRECTORY = "war";
    private String fileName;
    private int depth;

    public WarReport(NestableArchive nestableArchive) {
        this(nestableArchive, 1);
    }

    public WarReport(NestableArchive nestableArchive, int depth) {
        super(DIRECTORY, 0, nestableArchive);
        StringBuffer sb = new StringBuffer(nestableArchive.getName());
        this.setFilename(sb.append(".html").toString());
        this.depth = depth;
    }

    public String getDirectory() {
        return DIRECTORY;
    }

    public void writeHtmlHead(BufferedWriter bw) throws IOException {
        if (this.depth == 1) {
            super.writeHtmlHead(bw);
        } else {
            bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.newLine());
            bw.write("<html>" + Dump.newLine());
            bw.write("<head>" + Dump.newLine());
            bw.write("  <title>JBoss Tattletale 1.2.0.Beta2: " + this.getName() + "</title>" + Dump.newLine());
            bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.newLine());
            bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"");
            for (int i = 1; i <= this.depth; ++i) {
                bw.write("../");
            }
            bw.write("style.css\">" + Dump.newLine());
            bw.write("</head>" + Dump.newLine());
        }
    }

    BufferedWriter getBufferedWriter() throws IOException {
        return this.getBufferedWriter(this.getFilename());
    }

    private String getFilename() {
        return this.fileName;
    }

    private void setFilename(String fileName) {
        this.fileName = fileName;
    }
}

