/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.forge.furnace.container.cdi.util.ArraysUtils;
import org.jboss.weld.literal.DefaultLiteral;

abstract class AbstractImmutableBean<T>
implements Bean<T> {
    private static final Logger LOG = Logger.getLogger(AbstractImmutableBean.class.getName());
    private final Class<?> beanClass;
    private final String name;
    private final Set<Annotation> qualifiers;
    private final Class<? extends Annotation> scope;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final Set<Type> types;
    private final boolean alternative;
    private final boolean nullable;
    private final Set<InjectionPoint> injectionPoints;
    private final String toString;

    public AbstractImmutableBean(Class<?> beanClass, String name, Set<Annotation> qualifiers, Class<? extends Annotation> scope, Set<Class<? extends Annotation>> stereotypes, Set<Type> types, boolean alternative, boolean nullable, Set<InjectionPoint> injectionPoints, String toString) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass cannot be null");
        }
        this.beanClass = beanClass;
        this.name = name;
        if (qualifiers == null) {
            this.qualifiers = Collections.singleton(DefaultLiteral.INSTANCE);
            LOG.finest("No qualifers provided for bean class " + beanClass + ", using singleton set of @Default");
        } else {
            this.qualifiers = new HashSet<Annotation>(qualifiers);
        }
        if (scope == null) {
            this.scope = Dependent.class;
            LOG.finest("No scope provided for bean class " + beanClass + ", using @Dependent");
        } else {
            this.scope = scope;
        }
        this.stereotypes = stereotypes == null ? Collections.emptySet() : new HashSet<Class<? extends Annotation>>(stereotypes);
        if (types == null) {
            this.types = ArraysUtils.asSet(Object.class, beanClass);
            LOG.finest("No types provided for bean class " + beanClass + ", using [java.lang.Object.class, " + beanClass.getName() + ".class]");
        } else {
            this.types = new HashSet<Type>(types);
        }
        this.injectionPoints = injectionPoints == null ? Collections.emptySet() : new HashSet<InjectionPoint>(injectionPoints);
        this.alternative = alternative;
        this.nullable = nullable;
        this.toString = toString != null ? toString : "Custom Bean with bean class " + beanClass + " and qualifiers " + qualifiers;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public String getName() {
        return this.name;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.unmodifiableSet(this.stereotypes);
    }

    public Set<Type> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String toString() {
        return this.toString;
    }
}

