/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.impl;

import java.io.IOException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.xadisk.bridge.proxies.impl.XADiskRemoteManagedConnection;
import org.xadisk.connector.outbound.XADiskConnectionFactoryImpl;
import org.xadisk.connector.outbound.XADiskManagedConnectionFactory;
import org.xadisk.filesystem.NativeXAFileSystem;

public class XADiskRemoteManagedConnectionFactory
extends XADiskManagedConnectionFactory {
    private static final long serialVersionUID = 1L;
    private String serverAddress;
    private Integer serverPort;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        try {
            return new XADiskRemoteManagedConnection(this.serverAddress, this.serverPort, NativeXAFileSystem.getXAFileSystem(super.getInstanceId()));
        }
        catch (IOException ioe) {
            throw new ResourceException((Throwable)ioe);
        }
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new XADiskConnectionFactoryImpl(this, cm);
    }

    public int hashCode() {
        return this.serverAddress.hashCode() + this.serverPort.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XADiskRemoteManagedConnectionFactory) {
            XADiskRemoteManagedConnectionFactory that = (XADiskRemoteManagedConnectionFactory)obj;
            return (that.serverAddress == null ? this.serverAddress == null : that.serverAddress.equalsIgnoreCase(this.serverAddress)) && that.serverPort.equals(this.serverPort);
        }
        return false;
    }
}

