/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.OnDiskInfo;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.pools.PooledBuffer;
import org.xadisk.filesystem.utilities.TransactionLogsUtility;
import org.xadisk.filesystem.workers.EventWorker;

public class GatheringDiskWriter
extends EventWorker {
    private final int cumulativeBufferSizeForDiskWrite;
    private final AtomicInteger cumulativeBufferSize = new AtomicInteger(0);
    private FileChannel transactionLogChannel;
    private final ConcurrentHashMap<TransactionInformation, ConcurrentLinkedQueue<Buffer>> transactionSubmittedBuffers = new ConcurrentHashMap(1000);
    private final NativeXAFileSystem xaFileSystem;
    private final long transactionLogFileMaxSize;
    private final ReentrantLock transactionLogLock = new ReentrantLock(false);
    private final String transactionLogBaseName;
    private int currentLogIndex;
    private final HashMap<Integer, Integer> transactionLogsAndOpenTransactions = new HashMap(2);
    private final HashMap<TransactionInformation, ArrayList<Integer>> transactionsAndLogsOccupied = new HashMap(1000);
    private final long maxNonPooledBufferSize;

    public GatheringDiskWriter(int cumulativeBufferSizeForDiskWrite, long transactionLogFileMaxSize, long maxNonPooledBufferSize, String transactionLogBaseName, NativeXAFileSystem theXAFileSystem) throws IOException {
        this.cumulativeBufferSizeForDiskWrite = cumulativeBufferSizeForDiskWrite;
        this.xaFileSystem = theXAFileSystem;
        this.transactionLogFileMaxSize = transactionLogFileMaxSize;
        this.transactionLogBaseName = transactionLogBaseName;
        this.maxNonPooledBufferSize = maxNonPooledBufferSize;
    }

    public void initialize() throws IOException {
        File currentTransactionLog = null;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            File temp = new File(this.transactionLogBaseName + "_" + i);
            if (temp.exists()) continue;
            currentTransactionLog = temp;
            this.currentLogIndex = i;
            break;
        }
        if (currentTransactionLog == null) {
            throw new IOException("System has reached its limit on number of transaction logs.");
        }
        this.transactionLogChannel = new FileOutputStream(currentTransactionLog, false).getChannel();
    }

    public void deInitialize() throws IOException {
        this.transactionLogChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEvent() {
        try {
            this.transactionLogLock.lock();
            ArrayList<Buffer> allBuffersToWrite = new ArrayList<Buffer>(1000);
            ArrayList<TransactionInformation> xidsList = new ArrayList<TransactionInformation>(1000);
            for (Map.Entry<TransactionInformation, ConcurrentLinkedQueue<Buffer>> entry : this.transactionSubmittedBuffers.entrySet()) {
                Buffer buffer;
                TransactionInformation xid = entry.getKey();
                ConcurrentLinkedQueue<Buffer> txnBuffers = this.transactionSubmittedBuffers.get(xid);
                while ((buffer = txnBuffers.poll()) != null) {
                    xidsList.add(xid);
                    allBuffersToWrite.add(buffer);
                }
            }
            TransactionInformation[] xids = xidsList.toArray(new TransactionInformation[0]);
            Buffer[] buffersArray = allBuffersToWrite.toArray(new Buffer[0]);
            this.writeBuffersToTransactionLog(buffersArray, xids, 0);
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRemainingBuffersNow(TransactionInformation xid) throws IOException {
        try {
            this.transactionLogLock.lock();
            ConcurrentLinkedQueue<Buffer> txnBuffers = this.transactionSubmittedBuffers.remove(xid);
            for (Buffer buffer : txnBuffers) {
                this.cumulativeBufferSize.getAndAdd(-buffer.getBuffer().remaining());
            }
            TransactionInformation[] xids = new TransactionInformation[txnBuffers.size()];
            for (int i = 0; i < xids.length; ++i) {
                xids[i] = xid;
            }
            this.writeBuffersToTransactionLog(txnBuffers.toArray(new Buffer[0]), xids, 0);
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    private void writeBuffersToTransactionLog(Buffer[] buffersArray, TransactionInformation[] xids, int offset) throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[buffersArray.length];
        long sizeToWriteNow = 0L;
        int canProcessTill = buffersArray.length - 1;
        for (int i = offset; i < buffersArray.length; ++i) {
            byteBufferArray[i] = buffersArray[i].getBuffer();
            if (sizeToWriteNow + (long)byteBufferArray[i].remaining() > this.transactionLogFileMaxSize) {
                canProcessTill = i - 1;
                break;
            }
            sizeToWriteNow += (long)byteBufferArray[i].remaining();
        }
        this.ensureLogFileCapacity(sizeToWriteNow);
        long entryPosition = this.transactionLogChannel.position();
        ArrayList<Integer> buffersToMakeOnDisk = new ArrayList<Integer>(1000);
        for (int i = offset; i <= canProcessTill; ++i) {
            byteBufferArray[i] = buffersArray[i].getBuffer();
            boolean makeCurrentOnDisk = buffersArray[i] instanceof PooledBuffer ? false : (this.xaFileSystem.getTotalNonPooledBufferSize() < this.maxNonPooledBufferSize * 3L / 4L ? false : (this.xaFileSystem.getTotalNonPooledBufferSize() < this.maxNonPooledBufferSize ? byteBufferArray[i].remaining() >= 1000 : true));
            if (makeCurrentOnDisk) {
                this.addLogPositionToTransaction(xids[i], this.currentLogIndex, entryPosition);
                buffersToMakeOnDisk.add(i);
                buffersArray[i].setOnDiskInfo(new OnDiskInfo(this.currentLogIndex, entryPosition));
            } else {
                this.addInMemoryBufferToTransaction(xids[i], buffersArray[i]);
            }
            entryPosition += (long)byteBufferArray[i].remaining();
        }
        for (long n = 0L; n < sizeToWriteNow; n += this.transactionLogChannel.write(byteBufferArray, offset, canProcessTill - offset + 1)) {
        }
        for (Integer indices : buffersToMakeOnDisk) {
            Buffer temp = buffersArray[indices];
            temp.makeOnDisk(temp.getOnDiskInfo());
        }
        if (canProcessTill < buffersArray.length - 1) {
            this.writeBuffersToTransactionLog(buffersArray, xids, canProcessTill + 1);
        }
    }

    private void addLogPositionToTransaction(TransactionInformation xid, int logFileIndex, long localPosition) {
        xid.getOwningSession().addLogPositionToTransaction(logFileIndex, localPosition);
        TransactionLogsUtility.trackTransactionLogsUsage(xid, this.transactionsAndLogsOccupied, this.transactionLogsAndOpenTransactions, logFileIndex);
    }

    private void addInMemoryBufferToTransaction(TransactionInformation xid, Buffer buffer) {
        xid.getOwningSession().addInMemoryBufferToTransaction(buffer);
    }

    public void submitBuffer(Buffer logEntry, TransactionInformation xid) {
        logEntry.flushByteBufferChanges();
        ConcurrentLinkedQueue<Buffer> txnBuffers = this.transactionSubmittedBuffers.get(xid);
        if (txnBuffers == null) {
            txnBuffers = new ConcurrentLinkedQueue();
            txnBuffers.add(logEntry);
            this.transactionSubmittedBuffers.put(xid, txnBuffers);
        } else {
            txnBuffers.add(logEntry);
        }
        int currentCumulativeSize = this.cumulativeBufferSize.addAndGet(logEntry.getBuffer().remaining());
        this.raiseEventThreadSafely(currentCumulativeSize);
    }

    private void raiseEventThreadSafely(int currentCumulativeSize) {
        if (currentCumulativeSize >= this.cumulativeBufferSizeForDiskWrite) {
            while (!this.cumulativeBufferSize.compareAndSet(currentCumulativeSize, 0)) {
                currentCumulativeSize = this.cumulativeBufferSize.get();
                if (currentCumulativeSize >= this.cumulativeBufferSizeForDiskWrite) continue;
                return;
            }
            this.raiseEvent();
        }
    }

    public void transactionCommitBegins(TransactionInformation xid) throws IOException {
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(xid, (byte)12));
        this.forceWrite(temp);
    }

    public void transactionCompletes(TransactionInformation xid, boolean isCommitted) throws IOException {
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(xid, isCommitted ? (byte)13 : 14));
        this.forceWrite(temp);
    }

    public void transactionPrepareCompletes(TransactionInformation xid) throws IOException {
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(xid, (byte)15));
        this.forceWrite(temp);
    }

    public void transactionPrepareCompletesForEventDequeue(TransactionInformation xid, FileSystemStateChangeEvent event) throws IOException {
        ArrayList<FileSystemStateChangeEvent> events = new ArrayList<FileSystemStateChangeEvent>(1);
        events.add(event);
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(xid, events, (byte)20));
        this.forceWrite(temp);
    }

    public void recordEndPointActivation(EndPointActivation activation) throws IOException {
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(activation, (byte)22));
        this.forceWrite(temp);
    }

    public void recordEndPointDeActivation(EndPointActivation activation) throws IOException {
        ByteBuffer temp = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(activation, (byte)23));
        this.forceWrite(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLog(ByteBuffer logEntryHeader) throws IOException {
        try {
            this.transactionLogLock.lock();
            long sizeToWrite = logEntryHeader.remaining();
            this.ensureLogFileCapacity(sizeToWrite);
            for (long n = 0L; n < sizeToWrite; n += (long)this.transactionLogChannel.write(logEntryHeader)) {
            }
            this.transactionLogChannel.force(false);
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] forceUndoLogAndData(TransactionInformation xid, ByteBuffer logEntryHeader, FileChannel contents, long contentPosition, long contentLength) throws IOException {
        long[] logPosition = new long[2];
        try {
            long headerSize;
            this.transactionLogLock.lock();
            long n = 0L;
            long totalLogSizeRequiredForThisRequest = headerSize = (long)logEntryHeader.remaining();
            if (contentLength > 0L) {
                totalLogSizeRequiredForThisRequest += contentLength;
            }
            this.ensureLogFileCapacity(totalLogSizeRequiredForThisRequest);
            logPosition[0] = this.currentLogIndex;
            logPosition[1] = this.transactionLogChannel.position();
            while (n < headerSize) {
                n += (long)this.transactionLogChannel.write(logEntryHeader);
            }
            if (contentLength > 0L) {
                long startingPosition = this.transactionLogChannel.position();
                contents.position(contentPosition);
                for (n = 0L; n < contentLength; n += this.transactionLogChannel.transferFrom(contents, startingPosition + n, NativeXAFileSystem.maxTransferToChannel(contentLength - n))) {
                }
                this.transactionLogChannel.position(startingPosition + n);
            }
            this.transactionLogChannel.force(false);
            this.addLogPositionToTransaction(xid, (int)logPosition[0], logPosition[1]);
            long[] lArray = logPosition;
            return lArray;
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceWrite(ByteBuffer buffer) throws IOException {
        try {
            this.transactionLogLock.lock();
            long sizeToWrite = buffer.remaining();
            this.ensureLogFileCapacity(sizeToWrite);
            for (long n = 0L; n < sizeToWrite; n += (long)this.transactionLogChannel.write(buffer)) {
            }
            this.transactionLogChannel.force(false);
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupTransactionInfo(TransactionInformation xid) throws IOException {
        try {
            this.transactionLogLock.lock();
            TransactionLogsUtility.deleteLogsIfPossible(xid, this.transactionsAndLogsOccupied, this.transactionLogsAndOpenTransactions, this.currentLogIndex, this.transactionLogBaseName, this.xaFileSystem.createDurableDiskSession());
            this.transactionsAndLogsOccupied.remove(xid);
        }
        finally {
            this.transactionLogLock.unlock();
        }
    }

    private void ensureLogFileCapacity(long sizeToWriteNow) throws IOException {
        if (this.transactionLogChannel.size() + sizeToWriteNow > this.transactionLogFileMaxSize) {
            File nextTransactionLog = null;
            for (int i = this.currentLogIndex + 1; i < Integer.MAX_VALUE; ++i) {
                File f = new File(this.transactionLogBaseName + "_" + i);
                if (f.exists()) continue;
                nextTransactionLog = f;
                this.transactionLogChannel.close();
                this.transactionLogChannel = new FileOutputStream(nextTransactionLog, true).getChannel();
                this.currentLogIndex = i;
                this.recordAllActivationsInNewLog();
                break;
            }
            if (nextTransactionLog == null) {
                throw new IOException("Transaction logs seems to be over...cannot proceed.");
            }
        }
    }

    private void recordAllActivationsInNewLog() throws IOException {
        for (EndPointActivation activation : this.xaFileSystem.getAllActivations()) {
            this.recordEndPointActivation(activation);
        }
    }

    public void release() {
        super.release();
    }

    public void run() {
        super.run();
    }
}

