/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.OrganizationModel;
import org.jboss.windup.graph.model.resource.FileModel;

@TypeValue(value="ArchiveModel:")
public interface ArchiveModel
extends FileModel {
    public static final String TYPE = "ArchiveModel:";
    public static final String ARCHIVE_NAME = "ArchiveModel:archiveName";
    public static final String UNZIPPED_DIRECTORY = "unzippedDirectory";
    public static final String PARENT_ARCHIVE = "parentArchive";

    @Adjacency(label="parentArchive", direction=Direction.IN)
    public ArchiveModel getParentArchive();

    @Adjacency(label="parentArchive", direction=Direction.IN)
    public void setParentArchive(ArchiveModel var1);

    @Property(value="ArchiveModel:archiveName")
    public String getArchiveName();

    @Property(value="ArchiveModel:archiveName")
    public void setArchiveName(String var1);

    @Property(value="unzippedDirectory")
    public void setUnzippedDirectory(String var1);

    @Property(value="unzippedDirectory")
    public String getUnzippedDirectory();

    @Adjacency(label="OrganizationModel:organizationModelToArchiveModel", direction=Direction.IN)
    public Iterable<OrganizationModel> getOrganizationModels();

    @JavaHandler
    public Iterable<FileModel> getAllFiles();

    @Adjacency(label="DuplicateArchive:canonicalArchive", direction=Direction.IN)
    public Iterable<DuplicateArchiveModel> getDuplicateArchives();

    @JavaHandler
    public ArchiveModel getRootArchiveModel();

    @JavaHandler
    public boolean containsArchive(ArchiveModel var1);

    public static abstract class Impl
    extends FileModel.Impl
    implements ArchiveModel,
    JavaHandlerContext<Vertex> {
        @Override
        public Iterable<FileModel> getAllFiles() {
            LinkedHashSet<FileModel> results = new LinkedHashSet<FileModel>();
            for (FileModel child : this.getFilesInDirectory()) {
                this.addAllFiles(results, child);
            }
            return results;
        }

        private void addAllFiles(Set<FileModel> files, FileModel file) {
            files.add(file);
            if (file instanceof ArchiveModel) {
                return;
            }
            for (FileModel child : file.getFilesInDirectory()) {
                this.addAllFiles(files, child);
            }
        }

        @Override
        public ArchiveModel getRootArchiveModel() {
            ArchiveModel archiveModel = this;
            while (archiveModel.getParentArchive() != null) {
                archiveModel = archiveModel.getParentArchive();
            }
            return (ArchiveModel)this.frame(archiveModel.asVertex());
        }

        @Override
        public boolean containsArchive(ArchiveModel archiveModel) {
            if (this.asVertex().equals(archiveModel.asVertex())) {
                return true;
            }
            if (archiveModel.getParentArchive() != null) {
                return this.containsArchive(archiveModel.getParentArchive());
            }
            return false;
        }
    }
}

