/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.metadata.RuleMetadataType;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.context.Context;

public class RuleUtils {
    private static final int MAX_WIDTH = 80;

    public static String prettyPrintRule(Rule rule) {
        StringBuilder result = new StringBuilder();
        if (rule instanceof Context) {
            Context context = (Context)rule;
            RuleProvider provider = (RuleProvider)context.get((Object)RuleMetadataType.RULE_PROVIDER);
            if (provider != null && provider.getMetadata() != null) {
                result.append(provider.getMetadata().getPhase().getSimpleName()).append(" - ");
                result.append(provider.getMetadata().getID()).append(" - ");
            }
            if (rule.getId() != null) {
                result.append(rule.getId());
            }
        }
        return result.toString();
    }

    public static String ruleToRuleContentsString(Rule originalRule, int indentLevel) {
        if (originalRule instanceof Context && ((Context)originalRule).containsKey((Object)RuleMetadataType.RULE_XML)) {
            return (String)((Context)originalRule).get((Object)RuleMetadataType.RULE_XML);
        }
        if (!(originalRule instanceof RuleBuilder)) {
            return RuleUtils.wrap(originalRule.toString(), 80, indentLevel);
        }
        RuleBuilder rule = (RuleBuilder)originalRule;
        StringBuilder result = new StringBuilder();
        if (indentLevel == 0) {
            result.append("addRule()");
        }
        for (Condition condition : rule.getConditions()) {
            String conditionToString = RuleUtils.conditionToString(condition, indentLevel + 1);
            if (conditionToString.isEmpty()) continue;
            result.append("\n");
            RuleUtils.insertPadding(result, indentLevel + 1);
            result.append(".when(").append(RuleUtils.wrap(conditionToString, 80, indentLevel + 2)).append(")");
        }
        for (Operation operation : rule.getOperations()) {
            String operationToString = RuleUtils.operationToString(operation, indentLevel + 1);
            if (operationToString.isEmpty()) continue;
            result.append("\n");
            RuleUtils.insertPadding(result, indentLevel + 1);
            result.append(".perform(").append(RuleUtils.wrap(operationToString, 80, indentLevel + 2)).append(")");
        }
        if (rule.getId() != null && !rule.getId().isEmpty()) {
            result.append("\n");
            RuleUtils.insertPadding(result, indentLevel);
            result.append("withId(\"").append(rule.getId()).append("\")");
        }
        if (rule.priority() != 0) {
            result.append("\n");
            RuleUtils.insertPadding(result, indentLevel);
            result.append(".withPriority(").append(rule.priority()).append(")");
        }
        return result.toString();
    }

    private static String conditionToString(Condition condition, int indentLevel) {
        if (condition instanceof RuleBuilder) {
            return RuleUtils.ruleToRuleContentsString((Rule)((RuleBuilder)condition), indentLevel + 1);
        }
        return condition == null ? "" : RuleUtils.wrap(condition.toString(), 80, indentLevel + 1);
    }

    private static String operationToString(Operation operation, int indentLevel) {
        if (operation instanceof RuleBuilder) {
            return RuleUtils.ruleToRuleContentsString((Rule)((RuleBuilder)operation), indentLevel + 1);
        }
        return operation == null ? "" : RuleUtils.wrap(operation.toString(), 80, indentLevel + 2);
    }

    private static String wrap(String str, int wrapLength, int indentLevel) {
        StringBuilder result = new StringBuilder();
        try (StringReader sr = new StringReader(str);){
            BufferedReader br = new BufferedReader(sr);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    result.append(RuleUtils.wrapLine(line, wrapLength, indentLevel)).append("\n");
                }
            }
            catch (IOException e) {
                throw new WindupException("Error... while reading a StringReader", (Throwable)e);
            }
        }
        return result.toString();
    }

    private static String wrapLine(String str, int wrapLength, int indentLevel) {
        if (str == null) {
            return null;
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        StringBuilder filler = new StringBuilder();
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == '.') {
                ++offset;
                filler.append('.');
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(46, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                if (wrappedLine.length() > 0) {
                    RuleUtils.insertPadding(wrappedLine, indentLevel);
                }
                wrappedLine.append((CharSequence)filler);
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(SystemUtils.LINE_SEPARATOR);
                offset = spaceToWrapAt;
            } else {
                if (wrappedLine.length() > 0) {
                    RuleUtils.insertPadding(wrappedLine, indentLevel);
                }
                wrappedLine.append((CharSequence)filler);
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(SystemUtils.LINE_SEPARATOR);
                offset += wrapLength;
            }
            filler.setLength(0);
        }
        if (wrappedLine.length() > 0) {
            RuleUtils.insertPadding(wrappedLine, indentLevel);
        }
        wrappedLine.append((CharSequence)filler);
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    private static void insertPadding(StringBuilder sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
    }
}

