/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation;

import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;

public class Log
extends DefaultOperationBuilder
implements Parameterized {
    private final Logger log;
    private final Logger.Level level;
    private final RegexParameterizedPatternBuilder messageBuilder;

    private Log(Logger log, Logger.Level level, String message) {
        Class<Object> caller = Log.findClassCaller();
        if (caller == null) {
            caller = Log.class;
        }
        log = Logger.getLogger(caller);
        if (level == null) {
            level = Logger.Level.INFO;
        }
        if (message == null) {
            message = "(null)";
        }
        this.log = log;
        this.level = level;
        this.messageBuilder = new RegexParameterizedPatternBuilder(message);
    }

    private Log(Logger.Level level, String message) {
        this(null, level, message);
    }

    public static Log message(Logger.Level level, String message) {
        return new Log(level, message);
    }

    public static Log message(Class<?> cls, Logger.Level level, String message) {
        return new Log(Logger.getLogger(cls), level, message);
    }

    public void perform(Rewrite event, EvaluationContext context) {
        switch (this.level) {
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace(this.messageBuilder.build(event, context));
                break;
            }
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug(this.messageBuilder.build(event, context));
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info(this.messageBuilder.build(event, context));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn(this.messageBuilder.build(event, context));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(this.messageBuilder.build(event, context));
            }
        }
    }

    public Set<String> getRequiredParameterNames() {
        return this.messageBuilder.getRequiredParameterNames();
    }

    public void setParameterStore(ParameterStore store) {
        this.messageBuilder.setParameterStore(store);
    }

    public String toString() {
        return "LOG[" + this.level + ", " + this.messageBuilder.toString() + "]";
    }

    private static Class<? extends StackTraceElement> findClassCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length; ++i) {
            StackTraceElement call = stackTrace[i];
            if (Log.class.isAssignableFrom(call.getClass())) continue;
            return call.getClass();
        }
        return null;
    }
}

