/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.GraphContextImpl;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.util.ExecutionStatistics;

public class GraphContextFactoryImpl
implements GraphContextFactory {
    private GraphApiCompositeClassLoaderProvider graphApiCompositeClassLoaderProvider;
    private Furnace furnace;
    private GraphTypeManager graphTypeManager;

    private Furnace getFurnace() {
        if (this.furnace == null) {
            this.furnace = SimpleContainer.getFurnace((ClassLoader)GraphContextFactory.class.getClassLoader());
        }
        return this.furnace;
    }

    private GraphApiCompositeClassLoaderProvider getGraphApiCompositeClassLoaderProvider() {
        if (this.graphApiCompositeClassLoaderProvider == null) {
            this.graphApiCompositeClassLoaderProvider = (GraphApiCompositeClassLoaderProvider)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphApiCompositeClassLoaderProvider.class).get();
        }
        return this.graphApiCompositeClassLoaderProvider;
    }

    private GraphTypeManager getGraphTypeManager() {
        if (this.graphTypeManager == null) {
            this.graphTypeManager = (GraphTypeManager)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphTypeManager.class).get();
        }
        return this.graphTypeManager;
    }

    public GraphContext create() {
        return (GraphContext)ExecutionStatistics.performBenchmarked((String)(GraphContextFactory.class.getName() + ".create(Path)"), () -> new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), this.getTempGraphDirectory()).create());
    }

    public GraphContext create(Path graphDir) {
        return (GraphContext)ExecutionStatistics.performBenchmarked((String)(GraphContextFactory.class.getName() + ".create(Path)"), () -> new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), graphDir).create());
    }

    public GraphContext load(Path graphDir) {
        return new GraphContextImpl(this.getFurnace(), this.getGraphTypeManager(), this.getGraphApiCompositeClassLoaderProvider(), graphDir).load();
    }

    private Path getTempGraphDirectory() {
        return new File(FileUtils.getTempDirectory(), "windupgraph_" + RandomStringUtils.randomAlphanumeric((int)6)).toPath();
    }
}

